package com.blt.other.cost.controller;

import com.blt.other.auth.service.UserService;
import com.blt.other.commons.dto.FinansysDetailDto;
import com.blt.other.commons.dto.FinansysDetailDtoData;
import com.blt.other.commons.utils.AxiosUtil;
import com.blt.other.commons.utils.CurUtils;
import com.bailuntec.cost.api.dto.CostDto;
import com.blt.other.cost.service.CostApplycallbackService;
import com.blt.other.cost.service.CostLogService;
import com.blt.other.cost.service.CostService;
import com.blt.other.database.model.CostApplycallbackDomain;
import com.blt.other.database.model.UserDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.util.Map;

@RestController
@RequestMapping("cost/finansys/")
public class CostFinansysDetailController {
    private Logger logger = LoggerFactory.getLogger(CostFinansysDetailController.class);

    @Autowired
    private CostApplycallbackService costApplycallbackService;

    @Autowired
    private CostService costService;
    @Autowired
    private CostLogService costLogService;
    @Autowired
    private UserService userService;

    @PostMapping("detail")
    public FinansysDetailDto getCostFinansysDetailDto(HttpServletResponse response, HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        // 获取 applyno
        String code = request.getParameter("code");
        String costNo = null;
        if (code.startsWith("CO")){
            costNo = code;
        }else {
            CostApplycallbackDomain costApplycallback = costApplycallbackService.getCostApplycallback(code);
            costNo = costApplycallback.getCostNo();
        }
        Map<String, Object> costByCostNo = costService.getCostByCostNo(costNo);
        CostDto cost = (CostDto) costByCostNo.get("cost");
        UserDomain user = userService.findOne(cost.getCreateUsercode());

        FinansysDetailDto finansysDetailDto = new FinansysDetailDto();
        finansysDetailDto.setSuccess(true);
        finansysDetailDto.setMsg("");

        FinansysDetailDtoData data = new FinansysDetailDtoData();
        data.setId(cost.getId());
        data.setDepartmentName(user.getDepartmentname1());
        data.setApplyUserName(cost.getCreateUsername());
        data.setBuyNo(cost.getCostNo());
        data.setImportant("");
        data.setApplyTime(cost.getCreateTime());
        if (1 == cost.getCostForm()) {
            data.setPayType(1);
        }else if (2 == cost.getCostForm()){
            data.setPayType(2);
        }else {
            if (1 == cost.getIsLend()){
                data.setPayType(1);
            }else {
                data.setPayType(2);
            }
        }
        data.setCompanyFullName(cost.getBankCompany()); // 收款/付款单位
        data.setSettleAccount("");
        data.setCompanyName(cost.getBankCompany()); // 收款/付款单位
        data.setPayWay("");
        data.setAccount(cost.getBankCard());//帐号
        // 费用理由
        if (1 == cost.getCostForm()){
            data.setRemark(cost.getTypeName());
            if (null != cost.getIsLend() && 2 == cost.getIsLend()){
                data.setRemark(cost.getCostReason());
            }
        }else {
            data.setRemark(cost.getCostReason());
        }
        // 币种、金额
        if (null != cost.getIsLend() && 2 == cost.getIsLend()){
            data.setUnitCode(cost.getPayDic());
            data.setAmount(cost.getPayPlanAmount());
            data.setTaxPrice(cost.getPayPlanAmount());//含税价
            try {
                data.setChineseAmount(CurUtils.digitUppercase(cost.getPayPlanAmountDto()));//中文金额
            } catch (Exception e) {
                logger.error("CostFinansysDetailController",e);
            }
        }else{
            data.setUnitCode(cost.getDic());
            data.setAmount(cost.getAmount());
            data.setTaxPrice(cost.getAmount());//含税价
            try {
                data.setChineseAmount(CurUtils.digitUppercase(cost.getAmountDto()));//中文金额
            } catch (Exception e) {
                logger.error("CostFinansysDetailController",e);
            }
        }
        data.setCWOperationer("");//财务
        data.setDepartmentManager("");//负责人
        data.setPayCompany(cost.getCompanyName());//付款主体
        data.setTaxFee(new BigDecimal(0));//增值税点
        data.setPayDay("");//付款方式，有账期
        data.setStorageTime("");//采购单完整入库时间
        data.setSupplierName("");//供应商名称
        data.setUserName(cost.getBankCardUser());//姓名
        data.setBankName(cost.getBankName());//银行名称
        data.setBankCard(cost.getBankCard()); //银行卡号
        data.setBalanceAmount(new BigDecimal(0));//余额
        data.setTaoBaoOrderNo("");
        data.setListLog(costLogService.getListLogs(costLogService.getListByCostNo(costNo)));  // 日志

        finansysDetailDto.setData(data);
        return finansysDetailDto;
    }
}
