package com.blt.other.commons.utils;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.purchasing.vo.CompanyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.*;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

import java.util.List;

public class CompanyUtil {

    private static Logger logger = LoggerFactory.getLogger(CompanyUtil.class);

    public static List<CompanyVo> getCompanyList(String postCompanyListApi) {

        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        MultiValueMap<String, String> params = new LinkedMultiValueMap<>();
        HttpEntity<MultiValueMap<String, String>> requestEntity = new HttpEntity<>(params, headers);
        ResponseEntity<String> response = restTemplate.exchange(postCompanyListApi, HttpMethod.POST, requestEntity, String.class);

        String strBody = null;
        if (response.getStatusCodeValue() == 200) {
            strBody = response.getBody();
        } else {
            return null;
        }
        strBody = strBody.toLowerCase();

        strBody = strBody.substring(strBody.indexOf("["), strBody.lastIndexOf("}"));
        return JsonUtilByFsJson.jsonToList(strBody, CompanyVo.class);
    }
}
