package com.blt.other.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.auth.dao.OaDepartmentMapper;
import com.blt.other.auth.model.OaDepartment;
import com.blt.other.auth.service.IOaDepartmentService;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaDepartmentServiceImpl extends ServiceImpl<OaDepartmentMapper, OaDepartment> implements IOaDepartmentService {

    @Resource
    IOaDepartmentService oaDepartmentService;

    @Override
    public List<OaDepartment> oaDepartment(@NonNull Integer companyId) {
        List<OaDepartment> oaDepartmentList = oaDepartmentService.list(new LambdaQueryWrapper<OaDepartment>()
                .eq(OaDepartment::getParentId, 0)
                .eq(OaDepartment::getCompanyId, companyId));
        return oaDepartmentList;
    }
}
