package com.blt.other;


import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * Swagger2配置类
 * </p>
 *
 * @author robbendev
 */
@Configuration
@EnableSwagger2
public class Swagger2Config {


    /**
     * 创建API应用
     * apiInfo() 增加API相关信息
     * 通过select()函数返回一个ApiSelectorBuilder实例,用来控制哪些接口暴露给Swagger来展现，
     * 本例采用指定扫描的包路径来定义指定要建立API的目录。
     *
     * @return
     */
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
                .apiInfo(apiInfo())
                .select()
                .apis(RequestHandlerSelectors.basePackage("com.gogirl"))
                .paths(PathSelectors.any())
                .build()
                .globalOperationParameters(defaultHeader())
                ;
    }

    private static List<Parameter> defaultHeader() {
        ParameterBuilder appType = new ParameterBuilder();
        appType.name("sourceFrom")
                .description("应用类型").modelRef(new ModelRef("string")).parameterType("header").required(false).build();
        ParameterBuilder appToken = new ParameterBuilder();
        appToken.name("token").description("令牌").modelRef(new ModelRef("string")).parameterType("header").required(false).build();

        List<Parameter> pars = new ArrayList<>();
        pars.add(appType.build());
        pars.add(appToken.build());
        return pars;
    }


    /**
     * 创建该API的基本信息（这些基本信息会展现在文档页面中）
     * 访问地址：http://项目实际地址/swagger-ui.html
     *
     * @return
     */
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
                .title("店员端接口文档")
                .description("")
                .termsOfServiceUrl("http://192.168.1.13")
                .contact("sunf")
                .version("1.0")
                .build();
    }
}
