package com.blt.other.module.auth.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.module.auth.dao.OaCompanyMapper;
import com.blt.other.module.auth.dao.OaDepartmentMapper;
import com.blt.other.module.auth.dao.OaUserMapper;
import com.blt.other.module.auth.model.OaCompany;
import com.blt.other.module.auth.model.OaDepartment;
import com.blt.other.module.auth.model.OaUser;
import com.blt.other.module.auth.service.IOaDepartmentService;
import com.blt.other.module.sys.dao.CostReviewerMapper;
import com.blt.other.module.sys.model.CostReviewer;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-12
 */
@Service
public class OaDepartmentServiceImpl extends ServiceImpl<OaDepartmentMapper, OaDepartment> implements IOaDepartmentService {
    @Resource
    CostReviewerMapper costReviewerMapper;
    @Resource
    OaUserMapper oaUserMapper;

    @Override
    public List<OaDepartment> primaryDepartment(@NonNull Integer companyId) {
        return this.list(new LambdaQueryWrapper<OaDepartment>()
                .eq(OaDepartment::getParentId, 0)
                .eq(OaDepartment::getCompanyId, companyId));
    }

    @Override
    public void modifyDepartmentReviewer(Integer userId, Integer oaDepartmentId, List<Integer> departmentReviewerUserIds) {
        OaUser currentOaUser = oaUserMapper.selectByOaUserId(userId);
        OaDepartment oaDepartment = baseMapper.selectByDepartmentId(oaDepartmentId);

        //记录更新时间
        oaDepartment.setLastUpdateTime(LocalDateTime.now());
        oaDepartment.setUpdateUserId(userId);
        oaDepartment.setUpdateUserName(currentOaUser.getUserName());
        baseMapper.updateById(oaDepartment);

        //删除旧审核人
        costReviewerMapper.delete(new LambdaQueryWrapper<CostReviewer>()
                .eq(CostReviewer::getType, CostReviewer.departmentReviewer)
                .eq(CostReviewer::getReferId, oaDepartmentId));

        //新增审核人
        departmentReviewerUserIds.forEach(departmentReviewerUserId -> {
            //新增审核人
            OaUser departmentReviewerOaUser = oaUserMapper.selectByOaUserId(departmentReviewerUserId);

            CostReviewer costReviewer = CostReviewer.builder()
                    .reviewerUserId(departmentReviewerUserId)
                    .reviewerUserName(departmentReviewerOaUser.getUserName())
                    .referId(oaDepartmentId)
                    .type(CostReviewer.departmentReviewer)
                    .build();

            costReviewerMapper.insert(costReviewer);
        });
    }

    @Override
    public void updateDepartmentMinimumReviewAmount(Integer oaDepartmentId, BigDecimal amount) {
        OaDepartment oaDepartment = baseMapper.selectByDepartmentId(oaDepartmentId);
        oaDepartment.setDepartmentMinimumReviewAmount(amount);
        baseMapper.updateById(oaDepartment);
    }

    @Override
    public List<OaDepartment> allOaDepartment() {
        return baseMapper.allOaDepartment();
    }

    @Resource
    OaCompanyMapper oaCompanyMapper;

    @Override
    public List<OaCompany> queryTree() {

        List<OaCompany> oaCompanyList = oaCompanyMapper.selectList(new LambdaQueryWrapper<>());
        List<OaDepartment> oaDepartmentList = baseMapper.selectList(new LambdaQueryWrapper<>());
        List<OaDepartment> oaDepartmentTree = this.listToTree(oaDepartmentList);

        Map<Integer, List<OaDepartment>> treeMap = oaDepartmentTree.stream().collect(
                Collectors.groupingBy(OaDepartment::getCompanyId));
        oaCompanyList.forEach(oaCompany -> {
            oaCompany.setOaDepartmentList(treeMap.get(oaCompany.getOaCompanyId()));
        });
        return oaCompanyList;
    }


    /**
     * 商品分类列表转成树形
     *
     * @param list 商品分类列表
     * @return 商品分类树🌲
     */
    private List<OaDepartment> listToTree(List<OaDepartment> list) {
        //用递归找子。
        List<OaDepartment> treeList = new ArrayList<>();
        for (OaDepartment tree : list) {
            if (tree.getParentId() == 0) {
                OaDepartment child = findChildren(tree, list);
                treeList.add(child);
            }
        }
        return treeList;
    }

    /**
     * 递归构建子树
     *
     * @param tree 根结点
     * @param list 商品分类列表
     * @return 商品分类树🌲
     */
    private OaDepartment findChildren(OaDepartment tree, List<OaDepartment> list) {
        for (OaDepartment node : list) {
            if (node.getParentId().equals(tree.getDepartmentId())) {
                if (tree.getChildList() == null) {
                    tree.setChildList(new ArrayList<>());
                }
                OaDepartment child = findChildren(node, list);
                tree.getChildList().add(child);
            }
        }
        return tree;
    }
}
