package com.blt.other.module.cost.service.impl.costtemplate;

import com.bailuntec.common.ListUtil;
import com.bailuntec.common.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.blt.other.common.exception.BizRuntimeException;
import com.blt.other.module.cost.dao.CostTemplateColMapper;
import com.blt.other.module.cost.dto.CostTemplateColApiReq;
import com.blt.other.module.cost.model.CostTemplate;
import com.blt.other.module.cost.model.CostTemplateCol;
import com.blt.other.module.cost.service.ICostTemplateBaseColService;
import com.blt.other.module.cost.service.ICostTemplateColService;
import com.blt.other.module.cost.service.ICostTemplateService;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 * 费用单模版 服务实现类
 * </p>
 *
 * @author robbendev
 * @since 2020-10-14
 */
@Service
public class CostTemplateColServiceImpl extends ServiceImpl<CostTemplateColMapper, CostTemplateCol> implements ICostTemplateColService {
    @Resource
    ICostTemplateService costTemplateService;
    @Resource
    ICostTemplateBaseColService costTemplateBaseColService;

    @Override
    public void delete(Integer id) {
        CostTemplateCol costTemplateCol = this.getById(id);
        if (costTemplateCol.getIsDefault()) {
            throw new BizRuntimeException("unable to remove default costTemplateCol");
        }
        this.removeById(id);
    }

    @Override
    public void modify(CostTemplateCol costTemplateCol) {
        if (costTemplateCol.getIsDefault()) {
            throw new BizRuntimeException("unable to modify default costTemplateCol");
        }
        this.updateById(costTemplateCol);
        if (costTemplateCol.getCostTemplateBaseCol() != null) {
            costTemplateBaseColService.updateById(costTemplateCol.getCostTemplateBaseCol());
        }
    }

    @Override
    public void add(CostTemplateCol costTemplateCol) {
        this.save(costTemplateCol);
    }

    @Override
    public void setCostTemplateCol(List<CostTemplate> costTemplateList) {
        List<Integer> costTemplateIds = costTemplateList.stream().map(CostTemplate::getId).collect(Collectors.toList());
        if (ListUtil.isNotEmpty(costTemplateIds)) {
            List<CostTemplateCol> costTemplateColList = this.list(new LambdaQueryWrapper<CostTemplateCol>()
                    .in(CostTemplateCol::getCostTemplateId, costTemplateIds));
            costTemplateBaseColService.setCostTemplateBaseCol(costTemplateColList);

            Map<Integer, List<CostTemplateCol>> map = costTemplateColList.stream().collect(Collectors.groupingBy(CostTemplateCol::getCostTemplateId));
            costTemplateList.forEach(costTemplate -> {
                costTemplate.setCostTemplateColList(map.get(costTemplate.getId()));
            });
        }
    }

    @Override
    public void setCostTemplateCol(CostTemplate costTemplate) {
        List<CostTemplateCol> costTemplateColList = this.list(new LambdaQueryWrapper<CostTemplateCol>()
                .eq(CostTemplateCol::getCostTemplateId, costTemplate.getId()));
        costTemplateBaseColService.setCostTemplateBaseCol(costTemplateColList);

        costTemplate.setCostTemplateColList(costTemplateColList);
    }

    @Override
    public List<CostTemplateCol> queryList(CostTemplateColApiReq.QueryListReq req) {

        return costTemplateService.queryDetail(req.getCostTemplateId()).getCostTemplateColList()
                .stream()
                //字段类目
                .filter(costTemplateCol -> StringUtils.isEmpty(req.getColCategory()) ||
                        costTemplateCol.getCostTemplateBaseCol().getColCategory().contains(req.getColCategory()))
                //字段提示
                .filter(costTemplateCol -> StringUtils.isEmpty(req.getPrompt()) ||
                        costTemplateCol.getCostTemplateBaseCol().getPrompt().contains(req.getPrompt()))
                //字段名称
                .filter(costTemplateCol -> StringUtils.isEmpty(req.getColName()) ||
                        costTemplateCol.getCostTemplateBaseCol().getColName().contains(req.getColName()))
                //字段类型
                .filter(costTemplateCol -> req.getColType() == null ||
                        costTemplateCol.getCostTemplateBaseCol().getColType().equals(req.getColType()))
                //是否必填
                .filter(costTemplateCol -> req.getIsRequired() == null ||
                        costTemplateCol.getIsRequired().equals(req.getIsRequired()))
                //创建人
                .filter(costTemplateCol -> req.getCreateUserId() == null ||
                        costTemplateCol.getCreateUserId().equals(req.getCreateUserId()))
                //更新人
                .filter(costTemplateCol -> req.getUpdateUserId() == null ||
                        costTemplateCol.getUpdateUserId().equals(req.getUpdateUserId()))
                //审批规则是否配置
                .filter(costTemplateCol -> req.getIsAutoRule() == null ||
                        req.getIsAutoRule().equals(costTemplateCol.getAutoRuleType() > 0))
                //审核匹配符号类型
                .filter(costTemplateCol -> req.getAutoRuleType() == null ||
                        costTemplateCol.getAutoRuleType().equals(req.getAutoRuleType()))
                //创建时间
                .filter(costTemplateCol -> req.getCreateTimeStart() == null ||
                        costTemplateCol.getCreateTime().compareTo(req.getCreateTimeStart()) >= 0)
                .filter(costTemplateCol -> req.getCreateTimeEnd() == null ||
                        costTemplateCol.getCreateTime().compareTo(req.getCreateTimeEnd()) <= 0)
                //更新时间
                .filter(costTemplateCol -> req.getUpdateTimeStart() == null ||
                        costTemplateCol.getLastUpdateTime().compareTo(req.getUpdateTimeStart()) >= 0)
                .filter(costTemplateCol -> req.getCreateTimeEnd() == null ||
                        costTemplateCol.getLastUpdateTime().compareTo(req.getCreateTimeEnd()) <= 0)
                .collect(Collectors.toList());

    }

    @Override
    public CostTemplateCol queryById(Integer id) {
        CostTemplateCol costTemplateCol = this.getById(id);
        costTemplateBaseColService.setCostTemplateBaseCol(costTemplateCol);
        return costTemplateCol;
    }
}
