package com.blt.other.other_purchasing.dao;

import com.blt.other.other_database.model.BuyDomain;
import com.blt.other.other_purchasing.dto.BuyExportDto;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

@Mapper
@Repository
public interface BuyDao {

    /**
     * 保存新生成的采购单
     * @param buyDomain
     * @return
     */
    Integer insert(BuyDomain buyDomain);

    /**
     * 根据 no 和 skucode 查询相同的采购单
     * @param buyDomain
     * @return
     */
    List<BuyDomain> selectByNoAndSkucode(BuyDomain buyDomain);

    /**
     * 获取全部采购单
     */
    List<BuyDomain> selectAll();

    Integer update(BuyDomain buyDomain);

    void updateInstallment(BuyDomain buyDomain);

    void deleteBuy(@Param("buyNo") String buyNo);

    BuyDomain selectBuy(BuyDomain buyDomain);

    /**
     * 根据 buyno 获取采购单信息
     * @param buyDomain
     * @return
     */
    List<BuyDomain> selectByBuyno(BuyDomain buyDomain);

    List<BuyDomain> selectBySkucode(String skucode);

    List<BuyDomain> selectByPlanNo(String planNo);

    List<BuyDomain> selectBySkuKeyWord(String searchKey);

    BuyDomain selectLastBuy();

    Integer updateNewBuyno(@Param("oldBuyno") String oldBuyno, @Param("newBuyno") String newBuyno);

    BuyDomain findByBuyNo(@Param("buyNo") String buyNo);

    /**
     * 根据buyid数组查询
     * @param buyIds
     * @return
     */
    List<BuyDomain> selectByIds(Integer[] buyIds);

    /**
     * 根据buyid数组获取导出的数据
     * @param buyIds
     * @return
     */
    List<BuyExportDto> selectExportByIds(Integer[] buyIds);

    /**
     * 查询资产负债表相关采购单
     * @param startDate
     * @param endDate
     * @return
     */
    List<BuyDomain> selectBalanceSheetBuy(@Param("startDate") Date startDate, @Param("endDate") Date endDate);
}
