package com.blt.other.other_cost.utils;

import com.blt.other.other_cost.service.CostService;
import com.blt.other.other_database.model.CostDomain;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * 费用工具类
 */
public class CostUtils {

    public static String getIdNum( CostService costService){
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumIntegerDigits(6);
        nf.setMinimumIntegerDigits(6);

        String result = "";
        CostDomain lastCost = costService.getLastCost();
        if (null == lastCost){
            result = nf.format(0);
        }else {
            String costNo = lastCost.getCostNo();
            if (costNo != null && costNo.contains("-")){
                costNo = costNo.split("-")[0];
            }
            if (null != costNo && (costNo.startsWith("F"))) {
                String[] os = costNo.split("F");
                result = nf.format(Integer.parseInt(os[1]) + 1);
            } else if (null != costNo && costNo.startsWith("SF")){
                String[] os = costNo.split("F");
                result = nf.format(Integer.parseInt(os[1]) + 1);
            }
            if (null == costNo){
                return "F000000";
            }
        }
        return "F"+result;
    }

    /**
     * 生成费用单号
     * @return
     */
//    public static String getCostNo() {
//        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
//        Random random = new Random();
//        String costNo = "CO"+sdf.format(new Date())+random.nextInt(9);
//        return costNo;
//    }

    /**
     * 生成 CostDomain 实例
     * @param request
     * @return
     */
    public static CostDomain createCostDomain(HttpServletRequest request,String costNo){
        String companyNo = request.getParameter("companyNo");
        String kindNo = request.getParameter("kindNo");
        String amountRequest = request.getParameter("amount");
        BigDecimal amount = null;
        if (null != amountRequest) {
            amount = new BigDecimal(amountRequest);
        }
        String costRemark = request.getParameter("costRemark");
        String createUsercode = request.getParameter("createUsercode");
        Integer subLogisticsSupplierId = null;//二级物流供应商ID，非物流费用单为NULL
        String subLogisticsStr = request.getParameter("subLogisticsSupplierId");
        if (subLogisticsStr != null && !"".equals(subLogisticsStr) && !"null".equals(subLogisticsStr)){
            subLogisticsSupplierId = Integer.valueOf(subLogisticsStr);
        }
        Integer logisticsSupplierId = null;//一级物流供应商ID，非物流费用单为NULL
        String logisticsStr = request.getParameter("logisticsSupplierId");
        if (logisticsStr != null && !"".equals(logisticsStr) && !"null".equals(logisticsStr)){
            logisticsSupplierId = Integer.valueOf(logisticsStr);
        }
        String bankName = request.getParameter("bankName");
        String bankCard = request.getParameter("bankCard");
        String bankCardUser = request.getParameter("bankCardUser");
        String bankCompany = request.getParameter("bankCompany");
        String morRemark = request.getParameter("morRemark");
        String costReason = request.getParameter("costReason");
        String isLendStr = request.getParameter("isLend");
        String dic = request.getParameter("dic");
        String detailKey = request.getParameter("detailKey");
        Integer isLend = null;
        if (null != isLendStr && !"null".equals(isLendStr)){
            isLend = Integer.parseInt(isLendStr);
        }
        String costFormStr = request.getParameter("costForm");
        Integer costForm = null;
        Integer isTax = 0;
        if (null != costFormStr && !"null".equals(costFormStr)){
            costForm = Integer.parseInt(costFormStr);
            if (1 == costForm){
                String isTaxStr = request.getParameter("isTax");
                if (null != isTaxStr){
                    isTax = Integer.parseInt(isTaxStr);
                }
            }
        }

        // 封装 CostDomain
        CostDomain costDomain = new CostDomain();
        costDomain.setCostNo(costNo);
        costDomain.setDetailKey(detailKey);
        costDomain.setCompanyNo(companyNo);
        costDomain.setKindNo(kindNo);
        costDomain.setAmount(amount);
        costDomain.setCostRemark(costRemark);
        costDomain.setCreateUsercode(createUsercode);
        costDomain.setSubLogisticsSupplierId(subLogisticsSupplierId);
        costDomain.setLogisticsSupplierId(logisticsSupplierId);
        costDomain.setBankName(bankName);
        costDomain.setBankCard(bankCard);
        costDomain.setBankCardUser(bankCardUser);
        costDomain.setBankCompany(bankCompany);
        costDomain.setMorRemark(morRemark);
        costDomain.setCostForm(costForm);
        costDomain.setCostReason(costReason);
        costDomain.setIsLend(isLend);
        costDomain.setDic(dic);
        costDomain.setIsTax(isTax);
        if (null != costForm && 3 == costForm){
            if (1 == isLend){
                // 借支
                costDomain.setTypeNo(null);
                costDomain.setKindNo(kindNo);
                String hadPay = request.getParameter("hadPay");
                if (null != hadPay && !"null".equals(hadPay)){
                    costDomain.setHadPay(new BigDecimal(hadPay));
                }
                String lendStatus = request.getParameter("lendStatus");
                if (null != lendStatus && !"null".equals(lendStatus)) {
                    costDomain.setLendStatus(Integer.parseInt(lendStatus));
                }
                String compensate = request.getParameter("compensate");
                if (null != compensate && !"null".equals(compensate)) {
                    costDomain.setCompensate(new BigDecimal(compensate));
                }
                String counteract = request.getParameter("counteract");
                if (null != counteract && !"null".equals(counteract)) {
                    costDomain.setCounteract(new BigDecimal(counteract));
                }
                String lendBalance = request.getParameter("lendBalance");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costDomain.setLendBalance(new BigDecimal(lendBalance));
                }
            }else if (2 == isLend){
                // 借还
                String supCostNo = request.getParameter("supCostNo");
                costDomain.setSupCostNo(supCostNo);
                costDomain.setTypeNo(null);
                costDomain.setKindNo(kindNo);
                String counteract = request.getParameter("counteract");
                if (null != counteract && !"null".equals(counteract)) {
                    costDomain.setCounteract(new BigDecimal(counteract));
                }
                String lendBalance = request.getParameter("lendBalance");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costDomain.setLendBalance(new BigDecimal(lendBalance));
                }

                String payDic = request.getParameter("payDic");
                if (null != lendBalance && !"null".equals(lendBalance)) {
                    costDomain.setPayDic(payDic);
                }
                String payCounteract = request.getParameter("payCounteract");
                if (null != payCounteract && !"null".equals(payCounteract)) {
                    costDomain.setPayCounteract(new BigDecimal(payCounteract));
                }
                String payLendBalance = request.getParameter("payLendBalance");
                if (null != payLendBalance && !"null".equals(payLendBalance)) {
                    costDomain.setPayLendBalance(new BigDecimal(payLendBalance));
                }
                String payPlanAmount = request.getParameter("payPlanAmount");
                if (null != payPlanAmount && !"null".equals(payPlanAmount)) {
                    costDomain.setPayPlanAmount(new BigDecimal(payPlanAmount));
                }
                String cur = request.getParameter("cur");
                if (null != cur && !"null".equals(cur)) {
                    costDomain.setPayCur(new BigDecimal(cur));
                }
            }
        }
//        if (null != isLend && 1 == isLend){
//            costDomain.setTypeNo(null);
//            costDomain.setKindNo(null);
//        }
        return costDomain;
    }
}
