package com.blt.other.other_cost.service.impl;

import com.blt.other.other_commons.utils.CompanyUtil;
import com.blt.other.other_cost.dao.CostCompanyDao;
import com.blt.other.other_cost.service.CostCompanyService;
import com.blt.other.other_database.model.CostCompanyDomain;
import com.blt.other.other_purchasing.vo.CompanyVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Random;

@Service
public class CostCompanyServiceImpl implements CostCompanyService {
    private static Logger logger = LoggerFactory.getLogger(CostCompanyServiceImpl.class);

    @Autowired
    private CostCompanyDao costCompanyDao;

    @Value("${url.api.postCompanyListApi}")
    private String postCompanyListApi;

    /**
     * 新增主体
     * @param companyName
     * @return
     */
    @Override
    public Integer saveCompany(String companyName) {
        return null;
    }

    @Override
    public String syncCompany() {

        List<CompanyVo> companyList = CompanyUtil.getCompanyList(postCompanyListApi);
        Integer result = 0;
        Integer update = 0;
        if (companyList != null && companyList.size() >= 1){
            CostCompanyDomain companyDomain = null;
            for (CompanyVo companyVo : companyList){
                // 根据公司名称判断是否已经存在公司主体
                companyDomain = new CostCompanyDomain();
                companyDomain.setValue(companyVo.getValue());
                companyDomain.setCompanyName(companyVo.getName());
                List<CostCompanyDomain> costCompanyDomains = costCompanyDao.selectByNameOrValue(companyDomain);
                if (null != costCompanyDomains && costCompanyDomains.size() >= 1){
                    // 如果表中已存在相同名称的主体，则 update（根据 companyNo）
                    String companyNo = costCompanyDomains.get(0).getCompanyNo();
                    companyDomain.setCompanyNo(companyNo);
                    if (isUpdate(costCompanyDomains.get(0),companyDomain)){
                        Integer Integer = costCompanyDao.update(companyDomain);
                        update += Integer;
                        if (Integer >= 1){
                            logger.warn("主体"+companyDomain+"已更新费用管理系统记录");
                        }
                    }
                    continue;
                }else {
                    companyDomain.setCompanyNo(createCompanyNo());
                    costCompanyDao.insertCompany(companyDomain);
                    result += 1;
                    logger.warn("主体："+companyDomain+" 已加入费用管理系统");
                }
            }
        }
        return "新增 "+result+" 条记录，更新 "+update+" 条记录";
    }

    @Override
    public List<CostCompanyDomain> getAllCompany() {

        List<CostCompanyDomain> costCompanyDomains = costCompanyDao.selectAll();
        return costCompanyDomains;
    }

    /**
     * 根据 companyNo 获取 company
     * @param companyNo
     * @return
     */
    @Override
    public CostCompanyDomain getCompanyByCompanyNo(String companyNo) {
        CostCompanyDomain costCompanyDomain = costCompanyDao.selectByNo(companyNo);
        return costCompanyDomain;
    }

    /**
     * 生成唯一的主体编号
     * @return
     */
    private String createCompanyNo(){
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        Random random = new Random();
        String companyNo = "COM"+sdf.format(new Date())+random.nextInt(9);
        CostCompanyDomain companyDomain = costCompanyDao.selectByNo(companyNo);
        while (null != companyDomain && null != companyDomain.getCompanyName()){
            companyNo = "COM"+sdf.format(new Date())+random.nextInt(9);
            companyDomain = costCompanyDao.selectByNo(companyNo);
        }
        return companyNo;
    }

    private boolean isUpdate(CostCompanyDomain exited,CostCompanyDomain forInsert){
        String companyName = exited.getCompanyName();
        Integer value = exited.getValue();
        String companyName1 = forInsert.getCompanyName();
        Integer value1 = forInsert.getValue();
        if ((""+companyName).equals(""+companyName1) && value == value1){
            return false;
        }
        return true;
    }
}
