package com.blt.other.other_supplier.dao;

import com.blt.other.other_database.model.SupplierDomain;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.function.Supplier;

@Mapper
@Repository
public interface SupplierDao {

    /**
     * 根据供应商 supplierid 获取供应商信息
     * @return
     */
    SupplierDomain select(Integer supplierid);

    /**
     * 获取供应商列表
     * @return
     */
    List<SupplierDomain> selectALlSupplier();

    /**
     * 新增供应商
     * @param supplierDomain
     * @return
     */
    Integer insert(SupplierDomain supplierDomain);

    /**
     * 根据供应商编号获取供应商信息
     * @param supplierNo
     * @return
     */
    SupplierDomain selectBySupplierNo(String supplierNo);

    /**
     * 根据 supplierName 和 skuTypeNo 获取供应商信息
     * @param supplierDomain
     * @return
     */
    List<SupplierDomain> selectBySupplierNameAndSkuTypeNo(SupplierDomain supplierDomain);

    /**
     * 根据 sku 大类获取供应商列表
     * @param skuTypeNo
     * @return
     */
    List<SupplierDomain> selectBySkuTypeNo(String skuTypeNo);

    /**
     * 根据关键字获取供应商
     * @param key
     * @return
     */
    List<SupplierDomain> selectByKey(@Param("key") String key);

    Integer delete(String supplierNo);

    Integer update(SupplierDomain supplier);
}
