package com.blt.other.other_supplier.controller;

import com.blt.other.other_commons.utils.AxiosUtil;
import com.blt.other.other_commons.utils.MyMapperUtil;
import com.blt.other.other_database.model.SkuTypeDomain;
import com.blt.other.other_database.model.SupplierDomain;
import com.blt.other.other_sku.service.SkuTypeService;
import com.blt.other.other_sku.service.SysProductService;
import com.blt.other.other_supplier.service.SupplierService;
import com.blt.other.other_supplier.vo.SupplierVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

@RestController
@RequestMapping(value = "supplier")
public class SupplierController {

    @Autowired
    private SupplierService supplierService;
    @Autowired
    private SkuTypeService skuTypeService;

    @PostMapping("/add/save")
    public Map<String,Object> save(HttpServletResponse response, HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = new HashMap<>();
        String createuseridstr = request.getParameter("createuserid");
        Integer createuserid = null;
        try{
            createuserid = Integer.parseInt(createuseridstr);
        }catch (NumberFormatException e){
            result.put("success",false);
            result.put("msg","请重新登陆");
            return result;
        }
        String name = (request.getParameter("name")).replaceAll(" ","");
        if ("".equals(name)){
            result.put("success",false);
            result.put("msg","请输入供应商名称");
            return result;
        }
        String skuTypeNo = (request.getParameter("skuTypeNo")).replaceAll(" ","");
        if ("".equals(skuTypeNo)){
            result.put("success",false);
            result.put("msg","请选择供应商类型");
            return result;
        }
        String contactname = request.getParameter("contactname");
        String contactphone = request.getParameter("contactphone");
        String contactemail = request.getParameter("contactemail");
        String bankname = (request.getParameter("bankname")).replaceAll(" ","");
        if ("".equals(bankname)){
            result.put("success",false);
            result.put("msg","请输入供应商收/付款平台");
            return result;
        }
        String cardno = (request.getParameter("cardno")).replaceAll(" ","");
        if ("".equals(cardno)){
            result.put("success",false);
            result.put("msg","请输入供应商收/付款账户");
            return result;
        }
        String cardusername = (request.getParameter("cardusername")).replaceAll(" ","");
        if ("".equals(cardusername)){
            result.put("success",false);
            result.put("msg","请输入收/付款持卡人");
            return result;
        }
        String from = request.getParameter("from");

        // 判断是否已经存在相同类型下的相同供应商：skuTypeNo、供应商名相同
        List<SupplierDomain> byNameAndSkuTypeNo = supplierService.getByNameAndSkuTypeNo(name, skuTypeNo);
        if (null != byNameAndSkuTypeNo && byNameAndSkuTypeNo.size() >= 1){
            result.put("success",false);
            result.put("msg","供应商已存在");
            result.put("suppliers",byNameAndSkuTypeNo);
            return result;
        }

        SupplierDomain supplierDomain = new SupplierDomain();
        supplierDomain.setCreateuserid(createuserid);
        supplierDomain.setName(name);
        supplierDomain.setContactname(contactname);
        supplierDomain.setContactphone(contactphone);
        supplierDomain.setContactemail(contactemail);
        supplierDomain.setBankname(bankname);
        supplierDomain.setCardno(cardno);
        supplierDomain.setCardusername(cardusername);
        supplierDomain.setSupplierFrom(from);
        supplierDomain.setSkuTypeNo(skuTypeNo);
        supplierDomain.setCreatetime(new Date());

        Integer integer = supplierService.saveSupplier(supplierDomain);

        result.put("success",true);
        result.put("supplier",supplierDomain);
        result.put("msg","供应商信息已保存");

        return result;
    }

    /**
     * 分页获取供应商
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getAllSupplier")
    public Map<String,Object> getAllSupplier(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        String pageNum = request.getParameter("pageNum");
        String pageSize = request.getParameter("pageSize");
        Map<String, Object> result = supplierService.getAllSupplier(Integer.parseInt(pageNum),Integer.parseInt(pageSize));
        result.put("success",true);

        return result;
    }

    /**
     * 获取所有供应商
     * @param response
     * @param request
     * @return
     */
    @GetMapping("/getAllSuppliers")
    public Map<String,Object> getAllSuppliers(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);

        Map<String, Object> result = supplierService.getAllSuppliers();
        result.put("success",true);
        return result;
    }

    @PostMapping("getSupplierByNo")
    public Map<String,Object> getSupplierByNo(HttpServletResponse response,HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();
        String supplierNo = request.getParameter("supplierNo");
        SupplierDomain supplierDomain = supplierService.getSupplierByNo(supplierNo);

        result.put("success",true);
        result.put("supplier",supplierDomain);

        return result;
    }

    @GetMapping("getSupplierByTypeNo")
    public Map<String,Object> getSupplierByTypeNo(HttpServletResponse response,HttpServletRequest request) {
        AxiosUtil.setCors(response, request);
        Map<String,Object> result = new HashMap<>();

        String skuTypeNo = request.getParameter("skuTypeNo");
        List<SupplierDomain> supplierBySkuTypeNo = supplierService.getSupplierBySkuTypeNo(skuTypeNo);

        result.put("success",true);
        result.put("suppliers",supplierBySkuTypeNo);

        return result;
    }

    @PostMapping("/delete")
    public Map<String,Object> delete(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        String supplierNo = request.getParameter("supplierNo");
        Map<String,Object> result = new HashMap<>();
        Integer del = supplierService.deleteSup(supplierNo);
        result.put("success",true);
        return result;
    }

    @PostMapping("/resave")
    public Map<String,Object> resave(HttpServletResponse response,HttpServletRequest request){
        AxiosUtil.setCors(response,request);
        Map<String,Object> result = null;
        Enumeration<String> params = request.getParameterNames();
        if (null != params && params.hasMoreElements()){
            String s = params.nextElement();
            SupplierVo supplierVo = (SupplierVo)MyMapperUtil.getObject(s, SupplierVo.class);
            SupplierDomain supplier = supplierVo.getSupplier();
            SkuTypeDomain type = skuTypeService.getBySkuTypeNo(supplier.getSkuTypeNo());
            supplier.setSkuTypeName(type.getSkuTypeName());
            Integer update = supplierService.update(supplierVo.getSupplier());
            if (null != update && update == 1){
                result = new HashMap<>();
                result.put("success",true);
                result.put("supplier",supplierVo.getSupplier());
            }
        }
        return result;
    }
}
