package com.blt.other.module.purchasing.service.impl;

import com.blt.other.module.auth.dao.UserDao;
import com.blt.other.module.database.model.BuyLogDomain;
import com.blt.other.module.database.model.UserDomain;
import com.blt.other.module.purchasing.dao.BuyLogDao;
import com.blt.other.module.purchasing.service.BuyLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service
public class BuyLogServiceImpl implements BuyLogService {

    @Autowired
    private BuyLogDao buyLogDao;
    @Autowired
    private UserDao userDao;

    @Override
    public Integer save(String buyno, Integer updateuserid, String updateMainNote) {
        BuyLogDomain buyLog = new BuyLogDomain();
        buyLog.setBuyno(buyno);
        buyLog.setUpdateTime(new Date());

        UserDomain user = userDao.selectByuserid(updateuserid);
        buyLog.setUpdateUsercode(user.getUsercode());
        buyLog.setUpdateUserid(updateuserid);
        buyLog.setUpdateUsername(user.getUsername());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        buyLog.setUpdateNote(sdf.format(buyLog.getUpdateTime())+"  "+updateMainNote+"  更新人："+user.getUsername());

        return buyLogDao.insert(buyLog);
    }

    @Override
    public List<BuyLogDomain> getListByBuyno(String buyno) {
        return buyLogDao.selectByBuyno(buyno);
    }

    @Override
    public List<String> getListLogs(List<BuyLogDomain> logs) {
        if (null != logs && logs.size() >= 1){
            List<String> list = new ArrayList<>();
            for (BuyLogDomain domain: logs){
                list.add(domain.getUpdateNote());
            }
            return list;
        }
        return null;
    }

    @Override
    public Integer updateNewBuyno(String oldBuyno, String newBuyno) {
        return buyLogDao.updateNewBuyno(oldBuyno,newBuyno);
    }
}
