package com.blt.other.other_entrepot.dao;

import com.blt.other.other_database.model.InventoryLogDomain;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

@Mapper
@Repository
public interface InventoryLogDao {

    /**
     * 生成库存日志记录
     * @param inventoryLogDomain
     * @return
     */
    Integer insert(InventoryLogDomain inventoryLogDomain);

    /**
     * 获取库存记录
     * @return
     */
    List<InventoryLogDomain> selectAll();

    /**
     * 根据库存日志编号获取日志详情
     * @param inventoryLogNo
     * @return
     */
    InventoryLogDomain selectByNo(String inventoryLogNo);

    /**
     * 根据库存编号获取日志列表
     * @param inventoryNo
     * @return
     */
    List<InventoryLogDomain> selectByInventoryNo(String inventoryNo);
}
