package com.blt.other.common.job;

import com.blt.other.common.job.CashierAnnexSyncJob;
import org.quartz.*;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CashierAnnexSyncConfiguration {

    // 扫描主体列表时间间隔：（秒）
    private static final int TIME = 86400;

    @Bean
    public JobDetail cashierAnnexSyncJobDetail() {
        return JobBuilder.newJob(CashierAnnexSyncJob.class).withIdentity("cashierAnnexSyncJob").storeDurably().build();
    }

    @Bean
    public Trigger cashierAnnexSyncJobTrigger() {
        SimpleScheduleBuilder simpleScheduleBuilder = SimpleScheduleBuilder.simpleSchedule()
                .withIntervalInSeconds(TIME).repeatForever();
        return TriggerBuilder.newTrigger().forJob(cashierAnnexSyncJobDetail())
                .withIdentity("cashierAnnexSyncTrigger")
                .withSchedule(simpleScheduleBuilder).build();
    }
}
