package com.blt.other.module.cost.controller;

import com.bailuntec.common.JsonUtilByFsJson;
import com.blt.other.common.util.AxiosUtil;
import com.blt.other.common.util.MyMapperUtil;
import com.blt.other.common.util.PathUtil;
import com.blt.other.module.cost.dao.CostDao;
import com.blt.other.module.cost.model.CostDomain;
import com.blt.other.module.cost.service.CostExportService;
import com.blt.other.module.cost.service.CostService;
import com.blt.other.module.cost.service.impl.cost.CostServiceFactory;
import com.blt.other.module.cost.vo.CostExportVo;
import com.blt.other.module.database.model.CostExpDomain;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author robbendev
 * @since 2020/12/16 1:59 下午
 */
@RestController
public class CostReportController {

    @Resource
    CostExportService costExportService;
    @Resource
    CostDao costDao;

    @PostMapping("/cost/list/exportList")
    public String exportList(HttpServletResponse response, HttpServletRequest request) {
        Enumeration<String> parameterNames = request.getParameterNames();
        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = (CostExportVo) MyMapperUtil.getObject(s, CostExportVo.class);
            String filePath = costExportService.exportFees(costExportVo.getParams().getExportNos());
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @PostMapping("/cost/list/exportListAll")
    public String exportListAll(HttpServletResponse response, HttpServletRequest request) {
        CostService costService = CostServiceFactory.getCostService();

        AxiosUtil.setCors(response, request);
        Enumeration<String> parameterNames = request.getParameterNames();

        if (null != parameterNames && parameterNames.hasMoreElements()) {
            String s = parameterNames.nextElement();
            CostExportVo costExportVo = JsonUtilByFsJson.jsonToBean(s, CostExportVo.class);
            List<String> exportNos;
            if (null != costExportVo.getParams().getKeys().getCostForm() && 3 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setIsLend(1);
            }
            if (null != costExportVo.getParams().getKeys().getCostForm() && 4 == costExportVo.getParams().getKeys().getCostForm()) {
                costExportVo.getParams().getKeys().setCostForm(3);
                costExportVo.getParams().getKeys().setIsLend(2);
            }
            exportNos = costDao.listCostNoAll(costExportVo);

            String filePath = costExportService.exportFees(exportNos);
            // 保存下载记录
            CostExpDomain exp = costExportService.saveRecord(costExportVo, filePath);
            return exp.getExpNo();
        }
        return null;
    }

    @GetMapping("/cost/list/download")
    public ResponseEntity<InputStreamResource> download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String pathNo = request.getParameter("pathNo");
        CostExpDomain exp = costExportService.getByExpNo(pathNo);
        String filePath = exp.getExpPath();
        String fileName = PathUtil.getFileName(filePath);
        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }

    @GetMapping("/cost/list/downloadCashierAnnex")
    public ResponseEntity<InputStreamResource> downCashierAnnex(HttpServletRequest request, HttpServletResponse response) throws IOException {


        String detailNo = request.getParameter("detailNo");
        CostDomain cost = costDao.selectByCostNo(detailNo);
        String filePath = null;
        String fileName = null;
        if (null != cost) {
            filePath = cost.getCashierFilePath();
            if (null != filePath) {
                fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            }
        } else {
            return null;
        }

        FileSystemResource file = new FileSystemResource(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Cache-Control", "no-cache, no-store, must-revalidate");
        // new String(fileName.getBytes("UTF-8"),"iso-8859-1") 解决文件下载的时候文件名乱码的问题
        headers.add("Content-Disposition", String.format("attachment; filename=\"%s\"", new String(fileName.getBytes("UTF-8"), "iso-8859-1")));
        headers.add("Pragma", "no-cache");
        headers.add("Expires", "0");

        return ResponseEntity
                .ok()
                .headers(headers)
                .contentLength(file.contentLength())
                .contentType(MediaType.parseMediaType("application/octet-stream"))
                .body(new InputStreamResource(file.getInputStream()));
    }
}
