﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
    /// <summary>
    /// pps 产品改回货
    /// </summary>
  public  class PPSPushBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromSeconds(60));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;

            if (now.Hour == 20 && now.Minute == 02)
            {
                try
                {
                    System.Console.WriteLine($"开始 推送pps回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                    new ReportServices().PPSReturnGoodsPush("walmart");
                    System.Console.WriteLine($"结束 推送pps回货数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                }
                catch (Exception ex)
                {
                    Console.WriteLine("推送pps回货异常"+ex.Message);
                    Console.WriteLine("推送pps回货异常"+ex.StackTrace);
                }
               
            }


        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
