﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Report;
using AutoTurnOver.Services;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DailyController : Controller
    {

        ///
        [HttpGet]
        public JsonResult PurchaseList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.List(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 调拨在途
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <param name="sku"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult TransferList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.TransferList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [UseAction]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【实时库存】->【搜索】页面", 0)]
        public JsonResult RealtimeList([FromQuery]dc_base_stock_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.RealtimeList(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        } 
        
        /// <summary>
        /// 供应链采购在途
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【供应链采购在途】->【搜索】页面", 0)]
        public JsonResult FullLinkPurchaseList([FromQuery]dc_base_stock_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.FullLinkPurchaseList(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        } 
        
        /// <summary>
        /// 供应链调拨在途
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【供应链调拨在途】->【搜索】页面", 0)]
        public JsonResult FullLinkTransferList([FromQuery]dc_base_stock_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.FullLinkTransferList(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        } 
        
        /// <summary>
        /// 供应链调拨在途
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【全链路在途订单】->【搜索】页面", 0)]
        public JsonResult FullLinkWaitPage([FromQuery]dc_base_full_link_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.FullLinkWaitPage(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        } 

         [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【暂存调拨单】->【搜索】页面", 0)]
        public JsonResult TempTransferList([FromQuery]temp_transfer_order_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.TempTransferList(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        } 


        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [UseAction]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【FBA实时库存】->【搜索】页面", 0)]
        public JsonResult RealtimeFbaList([FromQuery]dc_base_stock_search_dto search_data)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.RealtimeFbaList(search_data, ref total);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        }

        public JsonResult RealtimeListSumFooter([FromQuery]dc_base_stock_search_dto search_data)
        {

            var services = new DailyServices();
            var total = 0;
            search_data.isSum = true;
            var list = services.RealtimeList(search_data, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_stock_dto() : list[0]);
        }
        public JsonResult RealtimeFbaListSumFooter([FromQuery]dc_base_stock_search_dto search_data)
        {

            var services = new DailyServices();
            var total = 0;
            search_data.isSum = true;
            var list = services.RealtimeFbaList(search_data, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_stock_fba_dto() : list[0]);
        }

        public JsonResult FullLinkPurchaseSumFooter([FromQuery]dc_base_stock_search_dto search_data)
        {

            var services = new DailyServices();
            var total = 0;
            search_data.isSum = true;
            var list = services.FullLinkPurchaseList(search_data, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new full_link_purchase_dto() : list[0]);
        }
        
        public JsonResult FullLinkTransferSumFooter([FromQuery]dc_base_stock_search_dto search_data)
        {

            var services = new DailyServices();
            var total = 0;
            search_data.isSum = true;
            var list = services.FullLinkTransferList(search_data, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new order_transfer_full_link_dto() : list[0]);
        }
        public JsonResult FullLinkWaitSumFooter([FromQuery]dc_base_full_link_search_dto search_data)
        {

            var services = new DailyServices();
            var total = 0;
            search_data.isSum = true;
            var list = services.FullLinkWaitPage(search_data, ref total);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_full_link_wait_order_dto() : list[0]);
        }

        /// <summary>
        /// 缺货推送记录
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="bailun_sku"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【修改在线数量日志】->【搜索】页面", 0)]
        public JsonResult ShortagePushList(string platform, string bailun_sku, int offset, int limit, DateTime? end_date, DateTime? start_date, string warehousecode, string warehousetype, int? warehousearea,int type = 0)
        {
            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.ShortagePushList(platform, bailun_sku, offset, limit, ref total, start_date, end_date, warehousecode, warehousetype, warehousearea, type);
                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        } 
        
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【转仓日志】->【搜索】页面", 0)]
        public JsonResult TransferWarehouseLogList([FromQuery]dc_aims_transfer_warehouse_log_search_dto search_data, [FromQuery]int offset, [FromQuery] int limit)
        {
            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.TransferWarehouseLogList(search_data, offset, limit, ref total);
                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }
        /// <summary>
        /// 缺货推送记录
        /// </summary>
        /// <param name="platform"></param>
        /// <param name="bailun_sku"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【离线下载】->【搜索】页面", 0)]
        public JsonResult TaskDownloadList(string user_name, string task_name, int offset, int limit, DateTime? start_date, DateTime? end_date)
        {
            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.TaskDownloadList(user_name, task_name, offset, limit, ref total, start_date, end_date);
                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }

        public JsonResult ExportShortagePush([FromQuery] export_sortage_push_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                dc_task_download_dao.PushData<export_sortage_push_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "改在线记录"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false, message = ex.Message });
            }

            //var user = AutoUtility.GetUser();
            //var memory = new DailyServices().ExportShortagePush(searchData, user);
            //return File(memory, "text/csv", $"{user.UserAccount}修改在线数量日志.csv");
        }


        /// <summary>
        /// 转仓日志导出
        /// </summary>
        /// <param name="search_data"></param>
        /// <returns></returns>
        public JsonResult ExportTransferWarehouseLogList([FromQuery] dc_aims_transfer_warehouse_log_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                dc_task_download_dao.PushData<dc_aims_transfer_warehouse_log_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "转仓日志"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false, message = ex.Message });
            }

            //var user = AutoUtility.GetUser();
            //var memory = new DailyServices().ExportShortagePush(searchData, user);
            //return File(memory, "text/csv", $"{user.UserAccount}修改在线数量日志.csv");
        }

        /// <summary>
        /// 预计到货
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult EstimatedArrivalList(string sku, string warehousecode, int index)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.EstimatedArrivalList(sku, warehousecode, index);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        [UseAction]
        public JsonResult ExportRealtime([FromQuery]dc_base_stock_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                search_data.limit = int.MaxValue;
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "实时库存"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false,message = ex.Message });
            }

        }
        
        public JsonResult ExportFullLinkTransfer([FromQuery]dc_base_stock_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                search_data.limit = int.MaxValue;
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "供应链调拨在途"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false,message = ex.Message });
            }

        }
        
        public JsonResult ExportFullLinkWait([FromQuery]dc_base_stock_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                search_data.limit = int.MaxValue;
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "供应链在途订单"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false,message = ex.Message });
            }

        }
        public JsonResult ExportFullLinkPurchase([FromQuery]dc_base_stock_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                search_data.limit = int.MaxValue;
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "供应链采购在途"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false,message = ex.Message });
            }

        }
        
        /// <summary>
        /// 导出Fba实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public JsonResult ExportFbaRealtime([FromQuery]dc_base_stock_search_dto search_data)
        {
            try
            {
                var user = AutoUtility.GetUser();
                search_data.limit = int.MaxValue;
                dc_task_download_dao.PushData<dc_base_stock_search_dto>(new dc_task_download
                {
                    parameter = search_data.ToJson(),
                    task_name = "Fba实时库存"
                }, user);
                return new JsonResult(new { success = true });
            }
            catch (Exception ex)
            {
                return new JsonResult(new { success = false,message = ex.Message });
            }
            
            //int total = 0;
            //var memory = new DailyServices().Export(user, monitor_status, searchType, key_words, warehousecode, supplier_name, offset, limit, ref total, warehousetype, warehousearea, has_tort: has_tort, buyer_name: buyer_name, start_date: start_date, end_date: end_date, f_start_date: f_start_date, f_end_date: f_end_date);
            //return File(memory, "text/csv", $"{user.UserAccount}实时库存.csv");
        }

        /// <summary>
        /// 缺货订单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public JsonResult OutOfStockOrderList(string sku, string warehousecode)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.OutOfStockOrderList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 库存监控
        /// </summary>
        /// <returns></returns>
        [UseAction]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【库存监控】->【搜索】页面", 0)]
        public JsonResult StockMonitorList(int? type, string bailun_sku, int offset, int limit, string order, string sort,
            DateTime? end_date, DateTime? start_date)
        {

            try
            {
                var services = new StockMonitorService();
                var page_data = services.GetPage(new dc_auto_stock_monitor_search_dto { type = type, bailun_sku = bailun_sku, page = offset + 1, rows = limit, sidx = sort, sord = order, start_date = start_date, end_date = end_date });

                return new JsonResult(new
                {
                    rows = page_data.Items,
                    total = page_data.TotalItems
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        }

        public JsonResult GetListingStatusPage(int offset, int limit, string order, string sort,
            DateTime? end_date, DateTime? start_date, string brand, int? has_tort, int? listing_status, int? warehousearea, int? source, string warehousetype, string warehouse_code, int? product_type, string product_code)
        {
            try
            {
                var services = new StockMonitorService();
                var page_data = services.GetListingStatusPage(new listing_status_view_search_dto
                {
                    product_type = product_type,
                    product_code = product_code,
                    source = source,
                    warehouse_code = warehouse_code,
                    warehousetype = warehousetype,
                    warehousearea = warehousearea,
                    listing_status = listing_status,
                    brand = brand,
                    has_tort = has_tort,
                    page = offset + 1,
                    rows = limit,
                    sidx = sort,
                    sord = order,
                    start_date = start_date,
                    end_date = end_date
                });

                return new JsonResult(new
                {
                    rows = page_data.Items,
                    total = page_data.TotalItems
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【实时数据】->【刊登监控】->【搜索】页面", 0)]
        public JsonResult GetShowField(string warehouse_code)
        {
            try
            {
                var services = new StockMonitorService();
                var datas = services.GetShowField(warehouse_code);

                return new JsonResult(datas);
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        [UseAction]
        public FileResult ExportStockMonitor(int? type, string bailun_sku,
            DateTime? end_date, DateTime? start_date)
        {
            var user = AutoUtility.GetUser();
            var memory = new StockMonitorService().Export(user, new dc_auto_stock_monitor_search_dto { type = type, bailun_sku = bailun_sku, page = 1, rows = int.MaxValue, start_date = start_date, end_date = end_date });
            return File(memory, "text/csv", $"{user.UserAccount}库存监控.csv");
        }


    }
}