﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Cors;
using System.IO;
using AutoTurnOver.Common;
using AutoTurnOver.DB;
using AutoTurnOver.Utility;
using AutoTurnOver.Models;
using AutoTurnOver.Models.ApiDto;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CommonController : BaseController
    {
        [HttpPost]
        public async Task<ActionResult<RequestResultDto>> FlieUpload(IFormFile file)
        {
            var fileName = Guid.NewGuid().ToString() + Path.GetExtension(file.FileName);
            var fileData = await QiNiuCloudHelper.UploadAsync(file.OpenReadStream(), fileName);
            return new RequestResultDto { success = true, data = fileData, data1 = fileName };
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ListWareHouse(string type, int? areaId)
        {


            var list = new CommonServices().ListWareHouse(type, areaId);
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseType()
        {
            var list = new CommonServices().ListWareHouseType();
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult GetUser()
        {
            var user = AutoUtility.GetUser();
            return new JsonResult(new { data = user });
        }

        [NoLogin]
        public ActionResult Logout()
        {
            MyHttpContext.Current.Session.Remove("UserInfo");
            MyHttpContext.Current.Response.Cookies.Delete("BailunToken");
            return Redirect("http://sso.bailuntec.com/?returnUrl=http://aims.bailuntec.com");
        }

        /// <summary>
        /// 获取仓库国家列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseArea()
        {
            var list = new CommonServices().ListWareHouseArea();
            return new JsonResult(list);
        }

        public JsonResult GetCategoryList()
        {
            var datas = ApiServices.GetCategoryList();
            return new JsonResult(datas);
        }

        public JsonResult GetProductTypeList()
        {
            var datas = daily.GetProductTypeList();
            return new JsonResult(datas);
        }

        public JsonResult SearchSupplier(string name)
        {
            var list = new CommonServices().SearchSupplier(name);
            return new JsonResult(list.Select(p => new
            {
                id = p.name,
                text = p.name
            }));
        }

        public JsonResult SearchSupplier2(string name)
        {
            var list = new CommonServices().SearchSupplier2(name);
            return new JsonResult(list.Select(p => new
            {
                id = p.name,
                text = p.name
            }));
        }

        public JsonResult SearchPurchaseUser(string name)
        {
            var list = new CommonServices().SearchPurchaseUser(name);
            return new JsonResult(list.Select(p => new
            {
                id = p.name,
                text = p.name
            }));
        }

        public JsonResult AccountList(string name)
        {
            try
            {
                var list = ApiServices.AccountList(name);
                return new JsonResult(list.Select(p => new
                {
                    id = p.Id,
                    text = p.PlatformEn + " - " + p.Account
                }));
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        public JsonResult ShipLogisticsList(string name)
        {
            try
            {
                var list = ApiServices.ShipLogisticsList(name);
                return new JsonResult(list.Select(p => new
                {
                    id = p.Line_Code,
                    text = p.Line_Code + " - " + p.Line_Name,
                    type = p.Start_Point
                }));
            }
            catch (Exception ex)
            {
                throw;
            }
        }
        public JsonResult ShipLogisticsListHead(string name,string type)
        {
            try
            {
                var list = ApiServices.ShipLogisticsListHead(name, type);
                return new JsonResult(list.Select(p => new
                {
                    id = p.Line_Code,
                    text = p.Line_Code + " - " + p.Line_Name,
                    type = p.Start_Point
                }));
            }
            catch (Exception ex)
            {
                throw;
            }
        }

        public JsonResult LogisticsCompanyList()
        {
            try
            {
                var list = ApiUtility.RealTimeShipLogisticsCompanyList();
                return new JsonResult(list.Select(p => new
                {
                    id = p.Company_Code,
                    text = p.Company_Code + " - " + p.Company_Name
                }));
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        public JsonResult PlatformList()
        {
            var datas = ApiServices.PlatformList();
            return new JsonResult(datas);
        }
        public JsonResult PlatformtypeWebsiteList(string platform_type)
        {
            var datas = ApiServices.PlatformtypeWebsiteList(platform_type).GroupBy(s => s.website).Select(s => new { website = s.Key }).ToList();
            return new JsonResult(datas);
        }
        public JsonResult PlatformtypeWebsiteAllList(string platform_type)
        {
            var datas = ApiServices.PlatformtypeWebsiteList(platform_type);
            return new JsonResult(datas);
        }

        public JsonResult BrandList()
        {
            var datas = new CommonServices().BrandList();
            return new JsonResult(datas);
        }

        /// <summary>
        /// crm 自定义出信模板
        /// </summary>
        /// <returns></returns>
        public JsonResult MessageCustomTemplateList()
        {
            var datas = ApiServices.MessageCustomTemplateList();
            return new JsonResult(datas);
        }

        /// <summary>
        /// 获取一二级的百伦数据
        /// </summary>
        /// <returns></returns>
        public JsonResult GetCategoryAll()
        {
            try
            {
                var datas = ApiServices.GetCategoryAll().Select(s => new
                {
                    id = s.C_ID,
                    pId = s.C_PARENTID,
                    name = s.C_CNAME,
                    open = false
                });
                return new JsonResult(new
                {
                    data = datas,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false
                });
            }

        }

        public JsonResult GetNewCategoryAll()
        {
            try
            {
                var datas = ApiServices.GetNewCategoryAll().Select(s => new
                {
                    id = s.id,
                    pId = s.parentId,
                    name = s.name,
                    open = false
                });
                return new JsonResult(new
                {
                    data = datas,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false
                });
            }

        }

        public JsonResult ListPlatformType()
        {
            try
            {
                var list = new Services.ConfigServices().ListPlatformType();
                return new JsonResult(list);
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        public JsonResult ListWebSite()
        {
            try
            {
                var list = new Services.ConfigServices().ListWebSite();
                return new JsonResult(list);
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        /// <summary>
        /// 查询物流费用
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        [HttpPost]
        public JsonResult GetFilterLogisticsAssignLine([FromBody]api_logistic_query_input_dto m)
        {
            try
            {
                var result = ApiUtility.GetFilterLogisticsAssignLine(m);
                return new JsonResult(new
                {
                    data = result,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }

        /// <summary>
        /// 查询平台分类
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        public JsonResult GetPlatformCategory(string plat, string site, string name)
        {
            var result = ApiUtility.GetPlatformCategory(new api_platform_category_input_dto
            {
                site = site,
                plat = plat
            }).Where(s => s.platCategory.Contains(name));
            return new JsonResult(result.Select(p => new
            {
                id = p.platCategoryId,
                text = p.platCategory
            }));

        }

        [HttpPost]
        public JsonResult GetPlatformFee([FromBody]api_platform_fee_input_dto m)
        {
            try
            {
                var result = ApiUtility.GetPlatformFee(m);
                return new JsonResult(new
                {
                    data = result,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    success = false,
                    message = ex.Message
                });
            }
        }
    }
}