﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 库容
    /// </summary>
    public class dc_base_storage_capacity
    {
        public int id { get; set; }
        public string warehouse_code { get; set; }

        /// <summary>
        /// 账号
        /// </summary>
        public string account { get; set; }
        public DateTime create_date { get; set; }
        public decimal stock { get; set; }
        public string create_user { get; set; }
        public DateTime update_date { get; set; }
        public string bailun_sku_warehouse_code { get; set; }

        /// <summary>
        /// 版本号
        /// </summary>
        public int version { get; set; }
    }

    public class dc_base_storage_capacity_dto: dc_base_storage_capacity
    {
        public string warehouse_name { get; set; }
    }
    public class dc_base_storage_capacity_query_dto
    {
        public List<data_dto> datas { get; set; }
        public class data_dto
        {
            public string bailun_sku { get; set; }
            public string warehouse_code { get; set; }

        }

    }
    public class dc_base_storage_capacity_search_dto
    {
        public string bailun_sku { get; set; }
        public string warehousecode { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
        public int page { get; set; }
        public int rows { get; set; }
        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
    }

    public class batch_dc_base_storage_capacity_log
    {
        public List<api_dc_base_storage_capacity_log> datas { get; set; }
    }
    public class api_dc_base_storage_capacity_log : dc_base_storage_capacity_log
    {
        public bool success { get; set; }
        public string message { get; set; }
    }
    public class dc_base_storage_capacity_log
    {
        public int id { get; set; }
        public string warehouse_code { get; set; }
        public string account { get; set; }
        public DateTime create_date { get; set; }

        /// <summary>
        /// 实际可用库存
        /// </summary>
        public decimal real_time_stock { get; set; }
        public string create_user { get; set; }
        public decimal quantity { get; set; }
        public int type { get; set; }
        public string bailun_sku_warehouse_code { get; set; }
        public string order_no { get; set; }
    }

    public class dc_base_storage_capacity_log_dto: dc_base_storage_capacity_log
    {
        public string warehouse_name { get; set; }
        public string type_str { get {
                return ((dc_base_storage_capacity_log_enum)type).ToString();
            } }
    }
    public class dc_base_storage_capacity_log_search_dto
    {
        public string bailun_sku { get; set; }
        public string warehousecode { get; set; }

        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }

        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
    }

    public enum dc_base_storage_capacity_log_enum
    {
        增加库容 =1,
        扣减库容 = 2,
        导入 = 3,
        调拨单驳回 = 5
    }
}
