﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.ApiDto
{
    /// <summary>
    /// 无库系统订单推送
    /// </summary>
    public class api_distribution_return_order_push_input_dto
    {
        public int supplierId { get; set; }
        /// <summary>
        /// 退货单号
        /// </summary>
        public string returnOrderNo { get; set; }
        /// <summary>
        /// 仓库名
        /// </summary>
        public string returnWarehouse { get; set; }
        public string returnWarehouseCode { get; set; }
        /// <summary>
        /// 时间
        /// </summary>
        public DateTime returnDate { get; set; }

        public List<sku_dto> skuList { get; set; }
        public class sku_dto
        {
            public string skuCode { get; set; }
            /// <summary>
            /// 退货数
            /// </summary>
            public int skuReturn { get; set; } 
            /// <summary>
            /// 退货金额
            /// </summary>
            public decimal skuReturnMonry { get; set; }
        }
    }
    public class api_distribution_return_order_push_response_dto
    {
        public int statusCode { get; set; }
        public string message { get; set; }
        public result_dto result { get; set; }
        public  class result_dto
        {
            public bool isSucceeded { get; set; }
            public string message { get; set; }
        }
    }

    public class api_oms_return_order_push_input_dto
    {
        public string originOrderNo { get; set; }
        public int platformType { get; set; }
        public string sellerName { get; set; }
        public receiptAddress_dto receiptAddress { get; set; }
        public List<proSkuItems_dto> proSkuItems { get; set; }
        public string wareHouseNo { get; set; }


        public class receiptAddress_dto
        {
            /// <summary>
            /// 广东省
            /// </summary>
            public string stateOrRegion { get; set; }

            /// <summary>
            /// 广州市
            /// </summary>
            public string city { get; set; }
            /// <summary>
            /// 天河区
            /// </summary>
            public string address { get; set; }

            /// <summary>
            /// 棠下
            /// </summary>
            public string address2 { get; set; }

            /// <summary>
            /// 测试人员
            /// </summary>
            public string receiver { get; set; }

            /// <summary>
            /// 526410
            /// </summary>
            public string postalCode { get; set; }
            public string phone { get; set; }
            public string phone2 { get; set; }

            /// <summary>
            /// CN
            /// </summary>
            public string CountryCode { get; set; }
        }
        public class proSkuItems_dto
        {
            public string skuNo { get; set; }
            public int quantity { get; set; }
        }
    }

    public class api_oms_return_order_push_response_dto
    {
        public result_dto result { get; set; }
        public bool success { get; set; }
        public string error { get; set; }

        public class result_dto
        {
            public List<result2_dto> result { get; set; }
            public class result2_dto
            {
                /// <summary>
                /// 是否处理成功
                /// </summary>
                public bool IsSuccess { get; set; }

                /// <summary>
                /// 退货单号
                /// </summary>
                public string OriginOrderNo { get; set; }

                /// <summary>
                /// 信息
                /// </summary>
                public string Message { get; set; }
            }

        }

       
        
    }
}
