﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 调拨在途全链路监控
    /// </summary>
    public class order_transfer_full_link_dto
    {
        public string sku { get; set; }
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        public string sku_name { get; set; }
        public decimal? stock { get; set; }
        public decimal not_storage { get; set; }
        public decimal? history_sevenday_sales { get; set; }
        public decimal? history_fourteenday_sales { get; set; }
        public decimal? history_thirtyday_sales { get; set; }
        public string buyer_name { get; set; }
        public string product_type_desc { get; set; }
        public int? forecast_type { get; set; }
        public int? sign_exe { get; set; }
        public string forecast_type_str
        {
            get
            {
                if (forecast_type == null)
                {
                    return "";
                }
                else
                {
                    return ((forecast_type_enum)forecast_type).ToString();
                }
            }
        }

        public enum forecast_type_enum
        {
            实际缺货 = 1, 预计缺货 = 2, 实际冗余 = 3, 预计冗余 = 4, 断货 = 5
        }
        public string order_no { get; set; }
        public string transporttype { get; set; }
        public int? stateid { get; set; }
        public string state_str
        {
            get
            {
                if (stateid == null)
                {
                    return "未知";
                }
                else
                {
                    return ((state_enum)stateid).ToString();
                }
            }
        }
        public enum state_enum
        {
            创建 = 0, 打包 = 1, 交运 = 2, 确认 = 3, 在途 = 4, 完成 = 5
        }

        public string trackingno { get; set; }
        public string transfer_no { get; set; }
        public string box_id { get; set; }
        public DateTime? node_date { get; set; }
        public string node_name { get; set; }
        public DateTime? expectarrivaltime { get; set; }
        public decimal? surplus_node_days { get; set; }
        public DateTime? node_expectarrivaltime { get; set; }
        public string logistics_code { get; set; }
        public string logistics_name { get; set; }
        public int? box_not_storage { get; set; }
    }
}
