﻿using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace AutoTurnOver.Utility
{
    public class ConfigHelper
    {
        private static IConfigurationRoot _iConfigurationBuilder;
        public static string GetValue(string key)
        {
            if (_iConfigurationBuilder == null)
            {
                var environmentName = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT");
                var configurationBuilder = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                .AddJsonFile($"appsettings.{environmentName}.json", true, reloadOnChange: true);
                _iConfigurationBuilder = configurationBuilder.Build();

            }
            return _iConfigurationBuilder[key];
        }

        public static string ConnectionString(string key)
        {

            if (_iConfigurationBuilder == null)
            {
                var environmentName = Environment.GetEnvironmentVariable("ASPNETCORE_ENVIRONMENT");
                var configurationBuilder = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile("appsettings.json", optional: true, reloadOnChange: true)
                .AddJsonFile($"appsettings.{environmentName}.json", true, reloadOnChange: true);
                _iConfigurationBuilder = configurationBuilder.Build();

            }

            return _iConfigurationBuilder.GetConnectionString(key);
        }
    }
}
