﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Models.Base;
using AutoTurnOver.Models.Report;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Text;

namespace AutoTurnOver.Services
{
    public class ForecastTaskServices
    {
        #region 配置页面

        public List<dc_report_cash_flow_forecast_task_dto> Page(dc_report_cash_flow_forecast_task_search_dto m, int offset, int limit, ref int total)
        {
            return DB.report_cash_flow_forecast_dao.Page(m, offset, limit, ref total);
        }


        public void Save(dc_report_cash_flow_forecast_task_input_dto m)
        {

             DB.report_cash_flow_forecast_dao.Save(m);
        }


        public dc_report_cash_flow_forecast_task GetById(int id)
        {
            return DB.report_cash_flow_forecast_dao.GetById(id);
        }



        #endregion

        public List<dynamic> GetInfo(report_cash_flow_view_forecast_task_search_dto search)
        {
            var order_list = DB.report_cash_flow_forecast_dao.GetInfo(search).views;

            List<dynamic> datas = new List<dynamic>();
            foreach (var item in order_list)
            {
                dynamic o = new ExpandoObject();
                o.date_type = string.Join(",", item.date_type);
                o.date_type_str = item.date_type_str;
                o.remarks = item.remarks;
                foreach (var dat_item in item.dates)
                {
                    var dic = (IDictionary<string, object>)o;
                    dic["occur_" + (dat_item.date_title)] = new { val = Math.Round(dat_item.occur_val, 2), btime = dat_item.btime, etime = dat_item.etime, data_type = item.date_type };
                    if (
                        item.date_type.Contains((int)dc_report_cash_flow_log_data_type_enum.销售数量)
                        //|| item.date_type==(int)dc_report_cash_flow_log_data_type_enum.利润 
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.退款
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.平台费用
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.释放销售成本
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.释放头程费用
                        )
                    {

                    }
                    else
                    {
                        dic["pay_" + (dat_item.date_title)] = new { val = Math.Round(dat_item.pay_val, 2), btime = dat_item.btime, etime = dat_item.etime, data_type = item.date_type };
                    }

                }

                datas.Add(o);
            }

            return datas;
        } public dc_report_cash_flow_forecast_task_date_dto GetDate(int id)
        {
            return DB.report_cash_flow_forecast_dao.GetDate(id);
        }

        public List<dc_report_cash_flow_log_dto> Export(dc_report_cash_flow_log_export_forecast_task_search_dto search)
        {
            return report_cash_flow_forecast_dao.Export(search);
        }

        public Page<dc_report_cash_flow_log_dto> LogPage(dc_report_cash_flow_log_export_forecast_task_search_dto search)
        {
            return report_cash_flow_forecast_dao.LogPage(search);
        }
    }
}
