﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 系统全局 SKU配置数据
    /// </summary>
   public class dc_sku_config_dto
    {
        public string warehouse_type { get; set; }

        public string warehouse_code { get; set; }

        public string warehouse_name { get; set; }

        public string bailun_sku { get; set; }

        public string sku_title { get; set; }

        public string product_code { get; set; }

        public string product_inner_code { get; set; }

        public string buyer_name { get; set; }

        /// <summary>
        /// 头程调拨初始值
        /// </summary>
        public decimal? transfer_config_delivery { get; set; }

        /// <summary>
        /// 头程调拨平均值
        /// </summary>
        public decimal? transfer_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数初始值
        /// </summary>
        public decimal? abroad_inbound_config_delivery { get; set; }

        /// <summary>
        /// 海外仓入库天数平均值
        /// </summary>
        public decimal abroad_inbound_delivery { get; set; }

        /// <summary>
        /// 海外仓打包天数初始
        /// </summary>
        public decimal transfer_bale_config_delivery { get; set; }

        /// <summary>
        /// 海外仓打包天数平均值
        /// </summary>
        public decimal transfer_bale_delivery { get; set; }

        /// <summary>
        /// 初始采购交期
        /// </summary>
        public decimal? supplier_delivery { get; set; }

        /// <summary>
        /// 最近一个单的预计到货时间
        /// </summary>
        public decimal? new_supplier_delivery { get; set; }

        /// <summary>
        /// 安全库存波峰天数(平均逾期天数)
        /// </summary>
        public decimal? average_overdue { get; set; }

        /// <summary>
        /// moq
        /// </summary>
        public decimal? moq { get; set; }

        /// <summary>
        /// 安全库存数量
        /// </summary>
        public decimal? quantity_safe { get; set; }

        /// <summary>
        /// 实际到货平均值
        /// </summary>
        public decimal? average_arrival { get; set; }

        /// <summary>
        /// 实际库存
        /// </summary>
        public decimal? stock { get; set; }

        /// <summary>
        /// 日均加权销量
        /// </summary>
        public decimal? quantity_safe_inventory { get; set; }

        /// <summary>
        /// 未来7天日均
        /// </summary>
        public decimal? forecast_sevenday_sales { get; set; }

        /// <summary>
        /// 周转天数（供应链长度）
        /// </summary>
        public decimal? turnover_days { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public decimal? realtime_quantity_purchase { get; set; }

        /// <summary>
        /// 调拨在途
        /// </summary>
        public decimal? realtime_quantity_transfer { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        public decimal? quantity_out_stock { get; set; }

        /// <summary>
        /// 监控状态
        /// </summary>
        public string monitor_status { get; set; }
    }

    public class new_supplier_delivery_dto
    {
        public string warehouse_code { get; set; }

        public string bailun_sku { get; set; }

        private decimal? _new_supplier_delivery;
        public decimal? new_supplier_delivery { get {
                if (_new_supplier_delivery > 0) return _new_supplier_delivery;
                else return null;
            } set { _new_supplier_delivery = value; } }
    }
}
