﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
   public class dc_auto_stock_monitor_dto
    {
        public int id { get; set; }
        /// <summary>
        /// 商品编码
        /// </summary>
        public string product_code { get; set; }
        /// <summary>
        /// 中文标题
        /// </summary>
        public string sku_title_cn { get; set; }
        /// <summary>
        /// 开发时间
        /// </summary>
        public DateTime? develop_time { get; set; }
        /// <summary>
        /// 推送产品库时间
        /// </summary>
        public DateTime? push_time { get; set; }
        /// <summary>
        /// 产品类型
        /// </summary>
        public string product_type_desc { get; set; }
        /// <summary>
        /// 采购员
        /// </summary>
        public string buyer_name { get; set; }
        /// <summary>
        /// 重量
        /// </summary>
        public decimal weight { get; set; }
        /// <summary>
        /// 监控状态
        /// </summary>
        public string monitor_status { get; set; }

        /// <summary>
        /// 停售状态
        /// </summary>
        public int status { get; set; }
        /// <summary>
        /// 停售状态
        /// </summary>
        public string status_str { get {
                switch (status)
                {
                    case 1:return "停售";
                    case 2:return "在售";
                    default:return "未知";
                }
            } }
        public int? source { get; set; }
        public string source_str { get {
                switch (source)
                {
                    case 1:return "精准开发";
                    case 2:return "线下（其他）";
                    case 3:return "线下美容";
                    case 6:return "普货供应商推荐";
                    case 7:return "服装产品中心";
                    case 11:return "无库供应商推荐";
                    default:return (source??0).ToString();
                }
            } }
        public decimal? unit_price { get; set; }
        public string bailun_sku { get; set; }
        /// <summary>
        /// 国内仓总缺货
        /// </summary>
        public decimal? china_quantity_out_stock { get; set; }
        /// <summary>
        /// 国外仓总缺货
        /// </summary>
        public decimal? not_china_quantity_out_stock { get; set; }
        /// <summary>
        /// 广州01 可用库存
        /// </summary>
        public decimal? guangzhou01_usable_stock { get; set; }
        /// <summary>
        /// 广州01 在途
        /// </summary>
        public decimal? guangzhou01_transfer_stock { get; set; }

        /// <summary>
        /// 广01总库存
        /// </summary>
        public decimal guangzhou01_stock { get
            {
                return (guangzhou01_transfer_stock ?? 0) + (guangzhou01_usable_stock ?? 0);
            } }
        /// <summary>
        /// 广州01总库存金额
        /// </summary>
        public decimal? guangzhou01_stock_amount { get {
                return guangzhou01_stock * (unit_price ?? 0);
            } }
        /// <summary>
        /// 海外仓uk仓 可配库存
        /// </summary>
        public decimal? haiwai_uk_usable_stock { get; set; }
        /// <summary>
        /// 海外仓uk仓 在途库存
        /// </summary>
        public decimal? haiwai_uk_transfer { get; set; }
        /// <summary>
        /// 海外仓us仓 可配库存
        /// </summary>
        public decimal? haiwai_us_usable_stock { get; set; }
        /// <summary>
        /// 海外仓us仓 在途库存
        /// </summary>
        public decimal? haiwai_us_transfer { get; set; }
        /// <summary>
        /// fba 可用库存
        /// </summary>
        public decimal? fba_usable_stock { get; set; }
        /// <summary>
        /// 海外仓库存 （可配+在途）
        /// </summary>
        public decimal? haiwai_usable_stock { get; set; }

        /// <summary>
        /// 海外仓库存金额
        /// </summary>
        public decimal? haiwai_stock_amount { get
            {
                return (haiwai_usable_stock ?? 0) * (unit_price ?? 0);
            } }

        /// <summary>
        /// 广州01 日均
        /// </summary>
        public decimal? guangzhou01_history_sevenday_sales { get; set; }

        /// <summary>
        /// 广01库存可消耗天数
        /// </summary>
        public decimal? guangzhou01_consume_days { get
            {
                if (guangzhou01_stock <= 0)
                {
                    return 0;
                }else if (guangzhou01_history_sevenday_sales==null || guangzhou01_history_sevenday_sales <= 0)
                {
                    return 0;
                }
                else
                {
                    return Math.Round(guangzhou01_stock*1.0M/ guangzhou01_history_sevenday_sales.Value, 2);
                }
            } }

        /// <summary>
        /// 海外仓uk仓 日均
        /// </summary>
        public decimal? haiwai_uk_history_sevenday_sales { get; set; }

        /// <summary>
        /// 海外 uk 仓库存可消耗天
        /// </summary>
        public decimal haiwai_uk_consume_days
        {
            get
            {
                var sum_stock = (haiwai_uk_usable_stock ?? 0) + (haiwai_uk_transfer ?? 0);
                if(sum_stock <= 0)
                {
                    return 0;
                }else if(haiwai_uk_history_sevenday_sales==null || haiwai_uk_history_sevenday_sales <= 0)
                {
                    return 0;
                }else
                {
                    return Math.Round(sum_stock * 1.0M/ haiwai_uk_history_sevenday_sales.Value, 2);
                }
            }
        }
        /// <summary>
        /// 海外仓us仓 日均
        /// </summary>
        public decimal? haiwai_us_history_sevenday_sales { get; set; }
        /// <summary>
        /// 海外 us 仓库存可消耗天
        /// </summary>
        public decimal haiwai_us_consume_days
        {
            get
            {
                var sum_stock = (haiwai_us_usable_stock ?? 0) + (haiwai_us_transfer ?? 0);
                if (sum_stock <= 0)
                {
                    return 0;
                }
                else if (haiwai_us_history_sevenday_sales == null || haiwai_us_history_sevenday_sales <= 0)
                {
                    return 0;
                }
                else
                {
                    return Math.Round(sum_stock * 1.0M / haiwai_us_history_sevenday_sales.Value, 2);
                }
            }
        }
        /// <summary>
        /// fba 仓 日均
        /// </summary>
        public decimal? haiwai_fba_history_sevenday_sales { get; set; }

        /// <summary>
        /// fba 仓库存可用天数
        /// </summary>
        public decimal fba_consume_days
        {
            get
            {
                var sum_stock = (fba_usable_stock ?? 0);
                if (sum_stock <= 0)
                {
                    return 0;
                }
                else if (haiwai_fba_history_sevenday_sales == null || haiwai_fba_history_sevenday_sales <= 0)
                {
                    return 0;
                }
                else
                {
                    return Math.Round(sum_stock * 1.0M / haiwai_fba_history_sevenday_sales.Value, 2);
                }
            }
        }
    }


    public class dc_auto_stock_monitor_search_dto : page_search_dto
    {
        /// <summary>
        /// 1 = us海外仓可上-美国仓有库存
        /// 2 = uk海外仓可上-英国国仓有库存
        /// 3 = 中国未订货
        /// 4 = us海外仓未订货
        /// 5 = uk海外仓未订货
        /// </summary>
        public int? type { get; set; }

        public string bailun_sku { get; set; }
        public DateTime? end_date { get; set; }
        public DateTime? start_date { get; set; }
    }
}
