﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.ApiDto
{
    public class api_logistic_query_input_dto
    {
        /// <summary>
        /// (必传)目的国家
        /// </summary>
        public string endCountries { get; set; }
        /// <summary>
        /// 站点
        /// </summary>
        public string Site { get; set; }
        /// <summary>
        /// (必传)长 
        /// </summary>
        public decimal Long { get; set; }
        /// <summary>
        /// (必传)宽
        /// </summary>
        public decimal width { get; set; }
        /// <summary>
        /// (必传)高
        /// </summary>
        public decimal high { get; set; }
        /// <summary>
        /// (必传)重量kg
        /// </summary>
        public decimal weightKg { get; set; }
        /// <summary>
        /// 邮编 传入则匹配
        /// </summary>
        //public string enterZip { get; set; } = "";
        /// <summary>
        /// 发货地 1-直邮 2-海外 3-头程
        /// </summary>
        public string startPoint { get; set; } = "";
        /// <summary>
        /// 邮递方式 1-小包平邮 2-小包挂号 3-快递 4-专线平邮 5-海外 6-调拨 7-专线挂号
        /// </summary>
        //public string postWay { get; set; } = "";
        /// <summary>
        /// 运输规定时间
        /// </summary>
        //public decimal theAging { get; set; } = 0;
        /// <summary>
        /// 指定平台
        /// </summary>
        public string platform { get; set; } = "";
        /// <summary>
        /// 货物性质,传入时需要数字
        /// </summary>
        //public string electrifiedType { get; set; } = "";

        /// <summary>
        /// 物流渠道编码
        /// </summary>
        //public string LogisticsCode { get; set; } = "";

        /// <summary>
        /// 官方物流编码
        /// </summary>
        //public string OfficeLogistic { get; set; } = "";

        /// <summary>
        /// 指定线路 多个则需要使用 , 分割
        /// </summary>
        //public string MainLineIds { get; set; }

        /// <summary>
        /// 指定线路Line_Code 多个则需要使用 , 分割
        /// </summary>
        public string LineCodes { get; set; } = "";
        /// <summary>
        /// 仓库Id  
        /// </summary>
       // public int warehouseId { get; set; } = 0;

        /// <summary>
        /// 仓库编码No
        /// </summary>
        public string warehouseNo { get; set; }

        /// <summary>
        /// sku信息 以  ,  分割 如已传长宽高重量 可不传 
        /// </summary>
        public string skus { get; set; } = "";

        /// <summary>
        /// 该票订单总金额 用于计算是否超过申报价值上限
        /// </summary>
        //public decimal orderPriceCNY { get; set; } = 0;

        /// <summary>
        /// 销售金额
        /// </summary>
       // public decimal SellMoney { get; set; } = 0;

        /// <summary>
        /// 查询禁用渠道
        /// </summary>
        //public bool isIgnoreAbandon { get; set; } = false;

        /// <summary>
        /// 查询失败渠道
        /// </summary>
        //public bool IsFails { get; set; } = false;

        /// <summary>
        /// 使用历史时间计算费用和可发国家
        /// </summary>
        //public DateTime? HistoryTime { get; set; }

        /// <summary>
        /// 0-不限 1-线下渠道 2-线上渠道
        /// </summary>
        //public int OnLineType { get; set; }

        /// <summary>
        /// 是否忽略泡重 0不忽略  1忽略
        /// </summary>
        //public bool isIgnoreVolumeWeight { get; set; } = true;

        //public string HeadType { get; set; } = "";
    }

    public class api_logistic_query_result_dto
    {
        public bool Success { get; set; }
        public string ErrorMessage { get; set; }
        public data_dto Data { get; set; }

        public class data_dto
        {
            public List<line_dto> successLines { get; set; }
            public List<line_dto> failLines { get; set; }
        }
        

        public class line_dto
        {
            public string Line_Code { get; set; }
            public string LineName { get; set; }
            public decimal TotalPrices { get; set; }
            public decimal HeadFee { get; set; }
            public string ErrorMsg { get; set; }

            /// <summary>
            /// 最快
            /// </summary>
            public decimal FastAging { get; set; }
            /// <summary>
            /// 最慢
            /// </summary>
            public decimal SlowAging { get; set; }
        }

    }
}
