﻿using AutoTurnOver.Models;
using Bailun.ServiceFabric;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace AutoTurnOver.DB
{
    public class dc_task_download_dao : connectionHelper
    {
        public static void PushData<T>(dc_task_download data, UserData user)
        {
            data.create_date = DateTime.Now;
            data.create_user = user.UserName;
            data.end_date  = new DateTime(1991,1,1);
            data.start_date  = new DateTime(1991,1,1);
            data.status  = (int)dc_task_download_status.待执行;
            data.result_file_url = "";
            data.error_message = "";
            data.error_stack_trace = "";

            var parList = new List<string>();
            var par = data.parameter.ToObject<T>();
            Type dataType = par.GetType();
            PropertyInfo[] properts = dataType.GetProperties(BindingFlags.Instance | BindingFlags.Public);
            if (properts.Any())
            {
                foreach (PropertyInfo item in properts)
                {
                    var obj = item.GetValue(par);
                    if(obj!=null && !string.IsNullOrWhiteSpace(obj.ToString()))
                    {
                        parList.Add($"{item.Name}={obj.ToString()}");
                    }
                }
            }

            if(parList!=null&& parList.Count >= 1)
            {
                data.parameter_show = string.Join("&", parList);
            }
            else
            {
                data.parameter_show = "";
            }
          _connection.Insert(data);
        } 


    }
}
