﻿using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.DB
{
    public class dc_base_supplier_dao : connectionHelper
    {
        public static void SynchroBailunSupplier()
        {
            var task_name = "SynchroBailunSupplier";
            var conn = _connection;
            // 查询最后一次成功抓取的记录
            var last_task_synchro_log = conn.QuerySingleOrDefault<task_synchro_log>(" select  * from task_synchro_log where task_name=@task_name and status=1 order by end_time desc limit 1 ", new { task_name = task_name });

            var new_task_synchro_log = new task_synchro_log
            {
                create_date = DateTime.Now,
                end_time = DateTime.Now,
                status = 0,
                task_name = task_name
            };

            if (last_task_synchro_log != null)
            {
                new_task_synchro_log.start_time = last_task_synchro_log.end_time.AddMinutes(-1);
            }
            else
            {
                new_task_synchro_log.start_time = new DateTime(2001, 05, 14);
            }

            new_task_synchro_log.id = conn.Insert(new_task_synchro_log) ?? 0;
            int count = 0;


            var page = 1;
            while (true)
            {
                var datas = ApiUtility.getSupplierList(page, new_task_synchro_log.start_time, new_task_synchro_log.end_time);
                if (datas == null || datas.Count <= 0)
                {
                    break;
                }
                page++;

                foreach (var item in datas)
                {
                    var db_data = new dc_base_supplier()
                    {
                        isaccept_refund = item.isaccept_refund??0,
                        isdaytakeinstore  =item.isdaytakeinstore??0,
                        name = item.name,
                        nostock  =item.nostock??0,
                        sup_id = item.id,
                        sup_value  =item.value,
                        companyaddress = item.companyaddress??"",
                        contactname = item.contactname??"",
                        contactphone = item.contactphone??"",
                        short_name = item.short_name ?? "",
                        laster_pockup_time = item.laster_pockup_time ?? "",
                        city = item.city??""
                    };


                    db_data.id = conn.QueryFirstOrDefault<int?>(" select id from dc_base_supplier where `sup_id`=@sup_id ", new { sup_id = db_data.sup_id }) ?? 0;
                    if (db_data.id > 0)
                    {
                        conn.Update(db_data);
                    }
                    else
                    {
                        conn.Insert(db_data);
                    }
                    count++;
                }
            }


            new_task_synchro_log.count = count;
            new_task_synchro_log.status = 1;
            conn.Update(new_task_synchro_log);
        }

    }
}
