﻿using AutoTurnOver.DB;
using AutoTurnOver.Services;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ShortagePush
{
    public class FirstBackgroundService : BackgroundService
    {


        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            // 每5分钟下一次首单
            Task.Factory.StartNew(() => {
                while (true)
                {
                    try
                    {
                        //System.Console.WriteLine($"开始下首单，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                        dc_auto_first_order_sku_dao.GeneratePurchaseAdvise();
                        //System.Console.WriteLine($"结束下首单，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");

                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                    }


                    Thread.Sleep(30 * 1000);
                }
            });


            return Task.CompletedTask;

        }

        

        public override void Dispose()
        {
            base.Dispose();
        }
    }
}
