﻿using AutoTurnOver.DB;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ResetOutofstock
{
  public  class CaseFlowBackgrounService : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;

        }
        private void DoWork(object state)
        {
            var now = DateTime.Now;
            if (now.Hour == 0 && now.Minute == 23)
            {
                Console.WriteLine($"开始 刷新现金流  订单数据 （销售），线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationOrder(now.AddMonths(-3),DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  订单数据（销售），线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 24)
            {
                Console.WriteLine($"开始 刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationPurchaseOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  采购数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 25)
            {
                Console.WriteLine($"开始 刷新现金流  调拨数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationTransferOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  调拨数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
            if (now.Hour == 0 && now.Minute == 26)
            {
                Console.WriteLine($"开始 刷新现金流  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationRefundOrder(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束刷新现金流  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            } 
            if (now.Hour == 0 && now.Minute == 27)
            {
                Console.WriteLine($"开始 刷新订单尾程费  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                report_cash_flow_dao.CalculationOrderCostLogistics(now.AddMonths(-3), DateTime.Parse(now.AddDays(-1).ToString("yyyy-MM-dd 23:59:59")));
                Console.WriteLine($"结束 刷新订单尾程费  退款数据，线程Id：{Thread.CurrentThread.ManagedThreadId}，{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
            }
           
        }

        public override void Dispose()
        {
            base.Dispose();
            _timer?.Dispose();
        }
    }
}
