﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;

namespace AutoTurnOver.Services
{
    /// <summary>
    /// 库容
    /// </summary>
    public class StorageCapacityServices
    {
        public List<dc_base_storage_capacity_dto> StorageCapacityList(dc_base_storage_capacity_search_dto m, int offset, int limit, ref int total)
        {
            return dc_base_storage_capacity_dao.StorageCapacityList(m, offset, limit, ref total);
        }

        public List<dc_base_storage_capacity_log_dto> StorageCapacityLogList(dc_base_storage_capacity_log_search_dto m, int offset, int limit, ref int total)
        {
            return dc_base_storage_capacity_dao.StorageCapacityLogList(m, offset, limit, ref total);
        }

        public List<dc_base_storage_capacity_dto> GetList(dc_base_storage_capacity_query_dto query)
        {
            return dc_base_storage_capacity_dao.GetList(query);
        }
        public  void AddLog(dc_base_storage_capacity_log data)
        {
            dc_base_storage_capacity_dao.AddLog(data);
        }

        public batch_dc_base_storage_capacity_log BatchAddLog(batch_dc_base_storage_capacity_log data)
        {
           return  dc_base_storage_capacity_dao.BatchAddLog(data);
        }

        public DataTable Import(Stream fileInfo, UserData user)
        {
            var data_set = EPPlusHelper.ReadExcel(fileInfo);
            var table = data_set.Tables[0];
            if (!table.Columns.Contains("导入结果")) table.Columns.Add("导入结果");
            if (!table.Columns.Contains("导入异常")) table.Columns.Add("导入异常");

            var warehouse_list = DB.common.ListWareHouse(null, null);

            DateTime now = DateTime.Now;

            int index = 1;
            foreach (DataRow row in table.Rows)
            {
                index++;
                try
                {
                    var warehouse_code = row["仓库编码"].ToString();
                    var account = row["账号"].ToString();
                    var stock_str = row["库容"].ToString();

                    if (string.IsNullOrWhiteSpace(warehouse_code)) throw new Exception("warehouse_code必填");
                    var warehouse_data = warehouse_list.SingleOrDefault(s => s.warehouse_code.Equals(warehouse_code, StringComparison.OrdinalIgnoreCase));
                    if (warehouse_data == null) { throw new Exception("仓库在系统中找不到"); }
                    var warehouse_name = warehouse_data.warehouse_name;

                    decimal stock = 0M;
                    if (!decimal.TryParse(stock_str, out stock))
                    {
                        throw new Exception("库容格式异常");
                    }

                    dc_base_storage_capacity_dao.AddLog(new dc_base_storage_capacity_log
                    {
                        create_user = user.UserName,
                        warehouse_code = warehouse_code,
                        account = account,
                        order_no = "",
                        quantity = stock,
                        type = (int)dc_base_storage_capacity_log_enum.导入
                    });


                    row["导入结果"] = "成功";
                    row["导入异常"] = "";
                }
                catch (Exception ex)
                {
                    row["导入结果"] = "失败";
                    row["导入异常"] = ex.Message;
                }
            }
            return table;
        }
    }
}
