﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 广告费分摊到订单上
    /// </summary>
    public class t_base_shopify_adfee_order
    {
        public long id { get; set; }

        /// <summary>
        /// t_base_shopify_adfee.data_id
        /// </summary>
        public string fee_data_id { get; set; }

        /// <summary>
        /// 订单的唯一约束 `origin_order_id`,`bailun_account_id`,`bailun_sku`
        /// </summary>
        public string order_unique { get; set; }
        public string origin_order_id { get; set; }
        public string bailun_account_id { get; set; }
        public string bailun_sku { get; set; }
        public string warehouse_code { get; set; }
        /// <summary>
        /// 费用周期（这里是美东时间 yyyy-MM-dd）
        /// </summary>
        public string date_str { get; set; }
        public string unique_id { get; set; }
        /// <summary>
        /// 原始费用美金
        /// </summary>
        public decimal origin_fee { get; set; }
        /// <summary>
        /// 原始费用 人民币
        /// </summary>
        public decimal origin_fee_cny { get; set; }
        public int is_delete { get; set; }
        /// <summary>
        /// 计算的时间范围 （北京时间）
        /// </summary>
        public DateTime calculation_btime { get; set; }
        /// <summary>
        /// 订单付款时间，北京时间
        /// </summary>
        public DateTime order_pay_time { get; set; }
        /// <summary>
        /// 计算的时间范围 （北京时间）
        /// </summary>
        public DateTime calculation_etime { get; set; }

        /// <summary>
        /// 范围内销售总额（USD）
        /// </summary>
        public decimal amount_total_usd { get; set; }
        /// <summary>
        /// 本订单的总销售额（USD）
        /// </summary>
        public decimal order_amount_total_usd { get; set; }
        /// <summary>
        /// 订单时间分摊到的广告费
        /// </summary>
        public decimal order_fee { get; set; }
        /// <summary>
        /// 订单实际分摊到的广告费 人民币
        /// </summary>
        public decimal order_fee_cny { get; set; }
    }
}
