﻿using AutoTurnOver.Models.Base;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_quantity_out_stock_dto
    {
        public int id { get; set; }

        public string bailun_sku { get; set; }

        public string warehouse_code { get; set; }

        public decimal quantity_out_stock { get; set; }

        public DateTime gmt_out_stock_modified { get; set; }
    }

    public class dc_quantity_out_stock_search_dto : page_search_dto
    {
        public DateTime? btime { get; set; }

        public DateTime? etime { get; set; }
    }

    public class dc_mid_transit
    {
        /// <summary>
        /// 
        /// </summary>
        [Description(@"")]
        public int id { get; set; }

        /// <summary>
        /// SKU
        /// </summary>
        [Description(@"SKU")]
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        [Description(@"仓库编码")]
        public string warehouse_code { get; set; }

        /// <summary>
        /// 采购在途数量
        /// </summary>
        [Description(@"采购在途数量")]
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 采购陆运在途数量
        /// </summary>
        [Description(@"采购陆运在途数量")]
        public int quantity_land_purchase { get; set; }

        /// <summary>
        /// 采购海运在途数量
        /// </summary>
        [Description(@"采购海运在途数量")]
        public int quantity_ocean_purchase { get; set; }

        /// <summary>
        /// 采购空运在途数量
        /// </summary>
        [Description(@"采购空运在途数量")]
        public int quantity_air_purchase { get; set; }

        /// <summary>
        /// 采购铁路在途数量
        /// </summary>
        [Description(@"采购铁路在途数量")]
        public int quantity_railway_purchase { get; set; }

        /// <summary>
        /// 采购在途数更新时间
        /// </summary>
        [Description(@"采购在途数更新时间")]
        public DateTime gmt_purchase_modified { get; set; }

        /// <summary>
        /// 调拨在途数量（总：调拨单+采购临时+暂存）
        /// </summary>
        [Description(@"调拨在途数量（总：调拨单+采购临时+暂存）")]
        public int quantity_transfer { get; set; }

        /// <summary>
        /// 调拨单在途
        /// </summary>
        [Description(@"调拨单在途")]
        public int quantity_transfer_order { get; set; }

        /// <summary>
        /// 调拨在途 采购临时
        /// </summary>
        [Description(@"调拨在途 采购临时")]
        public int quantity_transfer_temp_schedule { get; set; }

        /// <summary>
        /// 调拨在途 暂存
        /// </summary>
        [Description(@"调拨在途 暂存")]
        public int quantity_transfer_temporary_storage { get; set; }

        /// <summary>
        /// 调拨计划在途数量
        /// </summary>
        [Description(@"调拨计划在途数量")]
        public int quantity_transfer_plan { get; set; }

        /// <summary>
        /// 调拨陆运在途数量
        /// </summary>
        [Description(@"调拨陆运在途数量")]
        public int quantity_land_transfer { get; set; }

        /// <summary>
        /// 调拨海运在途数量
        /// </summary>
        [Description(@"调拨海运在途数量")]
        public int quantity_ocean_transfer { get; set; }

        /// <summary>
        /// 调拨空运在途数量
        /// </summary>
        [Description(@"调拨空运在途数量")]
        public int quantity_air_transfer { get; set; }

        /// <summary>
        /// 调拨铁路在途数量
        /// </summary>
        [Description(@"调拨铁路在途数量")]
        public int quantity_railway_transfer { get; set; }

        /// <summary>
        /// 调拨在途数更新时间
        /// </summary>
        [Description(@"调拨在途数更新时间")]
        public DateTime gmt_transfer_modified { get; set; }

        /// <summary>
        /// 缺货数量
        /// </summary>
        [Description(@"缺货数量")]
        public int quantity_out_stock { get; set; }

        /// <summary>
        /// 缺货数更新时间
        /// </summary>
        [Description(@"缺货数更新时间")]
        public DateTime gmt_out_stock_modified { get; set; }

        /// <summary>
        /// 未发货数量
        /// </summary>
        [Description(@"未发货数量")]
        public int quantity_unshipped { get; set; }

        /// <summary>
        /// 未发货数更新时间
        /// </summary>
        [Description(@"未发货数更新时间")]
        public DateTime gmt_unshipped_modified { get; set; }

        /// <summary>
        /// 公司Id,0和1是百伦
        /// </summary>
        [Description(@"公司Id,0和1是百伦")]
        public int company_id { get; set; }

        /// <summary>
        /// 采购在途金额 = sum(采购单单价 * 采购单数量)
        /// </summary>
        [Description(@"采购在途金额 = sum(采购单单价 * 采购单数量)")]
        public decimal amount_purchase_transit { get; set; }

        /// <summary>
        /// 未发货订单号
        /// </summary>
        [Description(@"未发货订单号")]
        public string bailun_order_ids { get; set; }

        /// <summary>
        /// 速卖通缺货
        /// </summary>
        [Description(@"速卖通缺货")]
        public int quantity_out_stock_aliexpress { get; set; }

        /// <summary>
        /// 亚马逊缺货
        /// </summary>
        [Description(@"亚马逊缺货")]
        public int quantity_out_stock_amazon { get; set; }

        /// <summary>
        /// 其他平台的需求
        /// </summary>
        [Description(@"其他平台的需求")]
        public int quantity_out_stock_other { get; set; }
    }
}
