﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models.ApiDto
{
    /// <summary>
    /// PDS销量
    /// </summary>
    public class PdsProviderProductSalesDto
    {
        /// <summary>
        /// 内部商品编码
        /// </summary>
        public string ProductCode { get; set; }

        /// <summary>
        /// PDS 开发竞品Item
        /// </summary>
        public string ProductItemId { get; set; }

        /// <summary>
        /// 平台站点
        /// </summary>
        public string PlatAndSite { get; set; }

        /// <summary>
        /// Ana 市场模糊7日销量
        /// </summary>
        public decimal? AnaMarketVagueSevenThSales { get; set; }

        /// <summary>
        /// 第一销售平台7日(源始平台)
        /// </summary>
        public decimal? FirstSalesPlatSevenTh { get; set; }

        /// <summary>
        /// 第二销售平台7日
        /// </summary>
        public decimal? SecondSalesPlatSevenTh { get; set; }

        /// <summary>
        /// 当前商品Sku编码列表
        /// </summary>
        public List<string> ProductSkuCodeList { get; set; } = new List<string>();
    }
}
