﻿using AutoTurnOver.Models;
using Dapper;

namespace AutoTurnOver.DB
{
    /// <summary>
    /// fba站点sku映射关系
    /// </summary>
    public class dc_base_sku_fba_mapping_dao : connectionHelper
    {
        /// <summary>
        /// 保存新增或修改
        /// </summary>
        /// <param name="data"></param>
        /// <returns></returns>
        public static bool Save(dc_base_sku_fba_mapping data)
        {
            DynamicParameters parameters = new DynamicParameters();
            parameters.Add("bailun_sku", data.bailun_sku);
            parameters.Add("warehouse_code", data.warehouse_code);
            var oldData = _connection.QuerySingleOrDefault<dc_base_sku_fba_mapping>(" SELECT * FROM dc_base_sku_fba_mapping WHERE bailun_sku = @bailun_sku AND warehouse_code = @warehouse_code; ", parameters);
            if (oldData == null)
            {
                _connection.Insert(data);
            }
            else
            {
                data.id = oldData.id;
                _connection.Update(data);
            }
            return true;
        }
    }
}
