﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 无库仓
    /// </summary>
    public class dc_not_stock
    {
        public int source { get; set; }

        public string source_str
        {
            get
            {
                return ((source_enum)source).ToString();
            }
        }

        public string bailun_sku { get; set; }

        public string product_inner_code { get; set; }

        public string sku_title { get; set; }

        public string suppliers_link { get; set; }

        public string suppliers_name { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public decimal oneday_sales { get; set; }

        /// <summary>
        /// 历史7日 日均
        /// </summary>
        public decimal history_sevenday_sales { get; set; }

        /// <summary>
        /// 缺货数
        /// </summary>
        public decimal quantity_out_stock { get; set; }

        /// <summary>
        /// 可配库存
        /// </summary>
        public decimal usable_stock { get; set; }

        /// <summary>
        /// 采购在途
        /// </summary>
        public decimal quantity_purchase { get; set; }

        /// <summary>
        /// 最小采购量
        /// </summary>
        public int moq { get; set; }

        /// <summary>
        /// 推送之后21日的总销量
        /// </summary>
        public decimal test_sales { get; set; }

        /// <summary>
        /// 最近7日的销量
        /// </summary>
        public decimal success_sales { get; set; }

        /// <summary>
        /// 推送时间
        /// </summary>
        public DateTime? push_time { get; set; }

        /// <summary>
        /// 是否成功
        /// 推送超过7天，且日均大于等于1
        /// </summary>
        public int success_state
        {
            get
            {
                if (push_time == null) return 0;
                if (success_sales >= 1 && (DateTime.Now - push_time.Value).TotalDays >= 7) return 1;
                else if (test_sales <= 0 && (DateTime.Now - push_time.Value).TotalDays >= 21) return 2;
                else return 3;
            }
        }


    }

    public class dc_not_stock_search_dto
    {

        public int? success_states { get; set; }

        public decimal? goods_sales_min { get; set; }

        public decimal? goods_sales_max { get; set; }

        /// <summary>
        /// 是否分销
        /// </summary>
        public int? source_type { get; set; }

        public int search_type { get; set; }
        public string key_words { get; set; }

        public DateTime? push_time_min { get; set; }
        public DateTime? push_time_max { get; set; }


    }
    public enum source_enum
    {
        线上 = 1,
        线下 = 2,
        线下美甲 = 3,
        线下供应商 = 4,
        登宇分销 = 5,
        线上供应商 = 6,
        服装产品中心 = 7,
        万邑通分销 = 9,
        托尼斯分销 = 10
    }
}
