﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 退货规则
    /// </summary>
    public class dc_auto_return_goods_config
    {
        public int id { get; set; }
        public string title { get; set; }
        public string warehouse_code { get; set; }
        public int suppliers_id { get; set; }
        public string suppliers_name { get; set; }
        public int has_return { get; set; }
        public int has_no_library { get; set; }
        public decimal first_inbound_days_min { get; set; }
        public decimal first_inbound_days_max { get; set; }
        public int sales_days_1 { get; set; }
        public decimal sales_weight_1 { get; set; }
        public int sales_days_2 { get; set; }
        public decimal sales_weight_2 { get; set; }
        public decimal sales_average_upper_limit { get; set; }
        public DateTime create_date { get; set; }
        public string create_user { get; set; }
        public DateTime delete_date { get; set; }
        public string delete_user { get; set; }

        /// <summary>
        /// 0 =正常 -1= 删除 1 =审核通过 -2 = 驳回 3= 已推送
        /// </summary>
        public int status { get; set; }
    }

    public class dc_auto_return_goods_config_dto: dc_auto_return_goods_config
    {
        public string status_str
        { get
            {
                return ((dc_auto_return_goods_config_status_enum)status).ToString();
            } }
        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        public string rule_str { get
            {
                return $" 过去 {sales_days_1} 天销量 * {sales_weight_1} +过去 {sales_days_2} 天销量 * {sales_weight_2} < {sales_average_upper_limit} ";
            } }
    }

    public class dc_auto_return_goods_config_search_dto
    {
        public int? offset { get; set; }
        public int? limit { get; set; }
        public string warehouse_code { get; set; }
        public string warehousetype { get; set; }

        public int? warehousearea { get; set; }
        /// <summary>
        /// 供应商
        /// </summary>
        public string supplier_name { get; set; }
        public int? has_return { get; set; }
        public int? has_no_library { get; set; }
        public int? status { get; set; }
    }

    public enum dc_auto_return_goods_config_status_enum
    {
        正常 = 0,
        删除 = -1
    }

}
