﻿using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class DailyController : Controller
    {

        ///
        [HttpGet]
        public JsonResult PurchaseList(string warehousecode, string sku)
        {
           
            var service = new Services.DailyServices();
            var list = service.List(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        /// <summary>
        /// 调拨在途
        /// </summary>
        /// <param name="warehousecode"></param>
        /// <param name="sku"></param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult TransferList(string warehousecode, string sku)
        {

            var service = new Services.DailyServices();
            var list = service.TransferList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = list.Count()
            });
        }

        

        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult RealtimeList(string sku,string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn,string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea,int? has_tort = null, string categoryIds = null)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.RealtimeList(sku, bailun_sku, warehousecode, product_inner_code, sku_title_cn, supplier_name, offset, limit, ref total, warehousetype, warehousearea, order: order, sort: sort, has_tort: has_tort, categoryIds: categoryIds);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }
            
        }

        public JsonResult RealtimeListSumFooter(string sku, string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn,string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea,int? has_tort = null, string categoryIds = null)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.RealtimeList(sku, bailun_sku, warehousecode, product_inner_code, sku_title_cn, supplier_name, offset, limit, ref total, warehousetype, warehousearea,true, has_tort: has_tort, categoryIds: categoryIds);

            return new JsonResult(list == null || list.Count <= 0 ? new dc_base_stock_dto() : list[0]);
        }

        

        /// <summary>
        /// 预计到货
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        public JsonResult EstimatedArrivalList(string sku, string warehousecode, int index)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.EstimatedArrivalList(sku, warehousecode, index);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        /// <summary>
        /// 导出实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public FileResult ExportRealtime(string sku, string bailun_sku, string warehousecode, string product_inner_code, string sku_title_cn, string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea, int? has_tort = null)
        {
            var user = AutoUtility.GetUser();
            int total = 0;
            var memory = new DailyServices().Export(user,sku, bailun_sku, warehousecode, product_inner_code, sku_title_cn, supplier_name, offset, limit, ref total, warehousetype, warehousearea, has_tort: has_tort);
            return File(memory, "text/csv", $"{user.UserAccount}实时库存.csv");
        }

        /// <summary>
        /// 缺货订单
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <returns></returns>
        public JsonResult OutOfStockOrderList(string sku, string warehousecode)
        {

            var services = new DailyServices();
            var total = 0;
            var list = services.OutOfStockOrderList(sku, warehousecode);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }
    }
}