﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using AutoTurnOver.Services;
using Microsoft.AspNetCore.Cors;
using System.IO;
using AutoTurnOver.Common;
using AutoTurnOver.DB;
using AutoTurnOver.Utility;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CommonController : BaseController
    {
        [HttpPost]
        public async Task<ActionResult<RequestResultDto>> FlieUpload(IFormFile file)
        {
            var fileName = Guid.NewGuid().ToString() + Path.GetExtension(file.FileName);
            var fileData = await QiNiuCloudHelper.UploadAsync(file.OpenReadStream(), fileName);
            return new RequestResultDto { success = true, data = fileData, data1 = fileName };
        }

        /// <summary>
        /// 获取仓库列表
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        public JsonResult ListWareHouse(string type,int? areaId)
        {
            
            
            var list = new CommonServices().ListWareHouse(type, areaId);
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseType()
        {
            var list = new CommonServices().ListWareHouseType();
            return new JsonResult(list);
        }

        /// <summary>
        /// 获取仓库类型列表
        /// </summary>
        /// <returns></returns>
        public JsonResult GetUser()
        {
            var user = AutoUtility.GetUser();
            return new JsonResult(new { data = user });
        }

        

        /// <summary>
        /// 获取仓库国家列表
        /// </summary>
        /// <returns></returns>
        public JsonResult ListWareHouseArea()
        {
            var list = new CommonServices().ListWareHouseArea();
            return new JsonResult(list);
        }


        public JsonResult GetCategoryList()
        {
            var datas = ApiServices.GetCategoryList();
            return new JsonResult(datas);
        }

        public JsonResult SearchSupplier(string name)
        {
            var list = new CommonServices().SearchSupplier(name);
            return new JsonResult(list.Select(p => new
            {
                id = p.name,
                text = p.name
            }));
        }

        public JsonResult SearchPurchaseUser(string name)
        {
            var list = new CommonServices().SearchPurchaseUser(name);
            return new JsonResult(list.Select(p => new
            {
                id = p.name,
                text = p.name
            }));
        }

        public JsonResult AccountList(string name)
        {
            try
            {
                var list = ApiServices.AccountList(name);
                return new JsonResult(list.Select(p => new
                {
                    id = p.Id,
                    text = p.PlatformEn + " - " + p.Account
                }));
            }
            catch (Exception ex)
            {
                throw;
            }
           
        }

        public JsonResult ShipLogisticsList(string name)
        {
            try
            {
                var list = ApiServices.ShipLogisticsList(name);
                return new JsonResult(list.Select(p => new
                {
                    id = p.Line_Code,
                    text = p.Line_Code + " - " + p.Line_Name
                }));
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        public JsonResult PlatformList()
        {
            var datas = ApiServices.PlatformList();
            return new JsonResult(datas);
        }

        /// <summary>
        /// crm 自定义出信模板
        /// </summary>
        /// <returns></returns>
        public JsonResult MessageCustomTemplateList()
        {
            var datas = ApiServices.MessageCustomTemplateList();
            return new JsonResult(datas);
        }

        /// <summary>
        /// 获取一二级的百伦数据
        /// </summary>
        /// <returns></returns>
        public JsonResult GetCategoryAll()
        {
            try
            {
                var datas = ApiServices.GetCategoryAll().Select(s=> new {
                    id = s.C_ID,
                    pId = s.C_PARENTID,
                    name = s.C_CNAME,
                    open = false
                });
                return new JsonResult(new
                {
                    data = datas,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false
                });
            }
            
        }

        public JsonResult GetNewCategoryAll()
        {
            try
            {
                var datas = ApiServices.GetNewCategoryAll().Select(s => new {
                    id = s.id,
                    pId = s.parentId,
                    name = s.name,
                    open = false
                });
                return new JsonResult(new
                {
                    data = datas,
                    success = true
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false
                });
            }

        }

        public JsonResult ListPlatformType()
        {
            try
            {
                var list = new Services.ConfigServices().ListPlatformType();
                return new JsonResult(list);
            }
            catch (Exception ex)
            {
                throw;
            }

        }

        public JsonResult ListWebSite()
        {
            try
            {
                var list = new Services.ConfigServices().ListWebSite();
                return new JsonResult(list);
            }
            catch (Exception ex)
            {
                throw;
            }

        }

    }
}