﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class dc_base_oms_pick
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 平台订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 账号id
        /// </summary>
        public int bailun_account_id { get; set; }

        /// <summary>
        /// 百伦订单号
        /// </summary>
        public string bailun_order_id { get; set; }

        /// <summary>
        /// 配货单号
        /// </summary>
        public string pick_order_id { get; set; }

        /// <summary>
        /// 追踪提供商
        /// </summary>
        public string tracking_provider { get; set; }

        /// <summary>
        /// 追踪单号
        /// </summary>
        public string tracking_order_id { get; set; }

        /// <summary>
        /// 百伦发货状态
        /// </summary>
        public string shipping_status { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? create_time { get; set; }

        /// <summary>
        /// 发货时间
        /// </summary>
        public DateTime? shipping_time { get; set; }

        /// <summary>
        /// 百伦SKU仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 百伦SKU仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 运单号
        /// </summary>
        public string logistics_order_id { get; set; }

        /// <summary>
        /// 运单线路
        /// </summary>
        public string logistics_order_name { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 配货数量
        /// </summary>
        public int quantity_picked { get; set; }

        /// <summary>
        /// 发货数量
        /// </summary>
        public int quantity_shipped { get; set; }

        /// <summary>
        /// 百伦sku
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 申报价值,USD
        /// </summary>
        public decimal declare_price { get; set; }

        /// <summary>
        /// 运费-配货单维度
        /// </summary>
        public decimal cost_shipping { get; set; }

        /// <summary>
        /// 包装费-配货单维度
        /// </summary>
        public decimal cost_packaging { get; set; }

        /// <summary>
        /// 出库重量,KG-配货单维度
        /// </summary>
        public decimal outbound_weight { get; set; }

        /// <summary>
        /// 运费-SKU维度
        /// </summary>
        public decimal bailun_sku_cost_shipping { get; set; }

        /// <summary>
        /// 包装费-SKU维度
        /// </summary>
        public decimal bailun_sku_cost_packaging { get; set; }

        /// <summary>
        /// 出库重量,G-SKU维度
        /// </summary>
        public decimal bailun_sku_outbound_weight { get; set; }

        /// <summary>
        /// 是否被删除-数据中心添加
        /// </summary>
        public int has_delete { get; set; }

        /// <summary>
        /// 公司Id, 默认0是无意义的
        /// </summary>
        public int company_id { get; set; }

        /// <summary>
        /// 是否推送第三方仓库
        /// </summary>
        public int has_pushed { get; set; }

        /// <summary>
        /// 总费用
        /// </summary>
        public decimal total_fee { get; set; }

        /// <summary>
        /// 运输费
        /// </summary>
        public decimal shipping { get; set; }

        /// <summary>
        /// 操作费
        /// </summary>
        public decimal opf { get; set; }

        /// <summary>
        /// 燃油附加费
        /// </summary>
        public decimal fsc { get; set; }

        /// <summary>
        /// 关税
        /// </summary>
        public decimal dt { get; set; }

        /// <summary>
        /// 挂号
        /// </summary>
        public decimal rsf { get; set; }

        /// <summary>
        /// 其他费用
        /// </summary>
        public decimal otf { get; set; }

        /// <summary>
        /// 仓租
        /// </summary>
        public decimal whf { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency_code { get; set; }

        /// <summary>
        /// 转人民币-汇率
        /// </summary>
        public decimal wms_to_cny_exchange_rate { get; set; }

        /// <summary>
        /// 转美元-汇率
        /// </summary>
        public decimal wms_to_usd_exchange_rate { get; set; }
    }
}
