﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Models;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class JitTagController : ControllerBase
    {
        #region 安全库存规则

        [HttpGet]
        [UseAction]
        public JsonResult JitTagList(int limit, int offset, string order, string sort,int? group_id = null)
        {
            var total = 0;
            var service = new Services.JitTagServices();
            var list = service.JitTagList(group_id??0, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        [UseAction]
        public JsonResult JitTagLogList(int limit, int offset, string order, string sort,string bailun_sku,DateTime? b_date,DateTime? e_date,int? tag_id = null)
        {
            var total = 0;
            var service = new Services.JitTagServices();
            var list = service.JitTagLogList(new dc_auto_jit_tag_log_search_dto {
                bailun_sku =bailun_sku,
                b_date =b_date,
                e_date = e_date,
                tag_id = tag_id
            } ,offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        public List<dc_auto_jit_tag> All()
        {
            return new Services.JitTagServices().All();
        }




        [HttpPost]
        [UseAction]
        public JsonResult SaveJitTag([FromBody]dc_auto_jit_tag m)
        {
            var result = new Services.JitTagServices().SaveJitTag(m, "");
            return new JsonResult(result);
        }


        /// <summary>
        /// 获取安全库存规则设置详情
        /// </summary>
        /// <param name="id">销售设置id</param>
        /// <returns></returns>
        [HttpGet]
        public JsonResult GetJitTagById(int id)
        {
            var m = new Services.JitTagServices().GetJitTagById(id);

            return new JsonResult(m);
        }

        #endregion
    }
}