﻿using AutoTurnOver.Models.ApiDto;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AutoTurnOver.DB
{
    public class ApiUtility
    {
        /// <summary>
        /// 批量修改sku默认发货仓
        /// </summary>
        public static void SaveDefaultWares(List<SaveDefaultWaresRequestDto> datas)
        {
            try
            {
                //查询采购建议明细 
                string url = ConfigHelper.GetValue("SaveDefaultWares");
                string resultStr = HttpHelper.Request(url, RequestType.POST, datas.ToJson(), "application/json", timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<SaveDefaultWaresResponseDto>();
                if (result == null)
                {
                    throw new Exception("skums 系统异常： 推送失败");
                }
                if (result.statusCode != 200)
                {
                    throw new Exception("skums 系统异常： " + result.message);
                }
            }
            catch (Exception ex)
            {
                throw new Exception("skums 系统异常： " + ex.Message);
            }

            return;
        }

        public static List<LmsShipLogisticsDto> ShipLogisticsList()
        {
            //查询采购建议明细 
            return RedisHelper.Get(RedisConsts.Lms_GetLogistics, () =>
            {
                string url = ConfigHelper.GetValue("Lms_GetLogistics");
                string resultStr = HttpHelper.Request(url, RequestType.GET, "", timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<LmsResultDto<List<LmsShipLogisticsDto>>>();
                if (result == null)
                {
                    throw new Exception("lms系统异常： 未获取到数据");
                }
                if (!result.Success)
                {
                    throw new Exception("lms系统异常： " + result.ErrorMessage);
                }
                return result.Data;
            });
        }

        public static List<LmsShipLogisticsDto> RealTimeShipLogisticsList()
        {
            string url = ConfigHelper.GetValue("Lms_GetLogistics");
            string resultStr = HttpHelper.Request(url, RequestType.GET, "", timeout: 1000 * 60 * 60 * 24);
            var result = resultStr.ToObj<LmsResultDto<List<LmsShipLogisticsDto>>>();
            if (result == null)
            {
                throw new Exception("lms系统异常： 未获取到数据");
            }
            if (!result.Success)
            {
                throw new Exception("lms系统异常： " + result.ErrorMessage);
            }
            return result.Data;
        }
        public static List<LmsShipLogisticsDto> RealTimeShipLogisticsCompanyList()
        {
            return RealTimeShipLogisticsList().GroupBy(s => new { s.Company_Code }).Select(s => new LmsShipLogisticsDto { Company_Code = s.Key.Company_Code, Company_Name = s.Max(v => v.Company_Name) }).ToList();
        }

        /// <summary>
        /// 抓取sku 刊登状态
        /// </summary>
        /// <returns></returns>
        public static List<api_pps_sku_status_response_dto.sku_dto> GetPPSSkuStatus(api_pps_sku_status_request_dto data)
        {
            try
            {
                //查询采购建议明细 
                string url = ConfigHelper.GetValue("PPSSkuStatus");
                string resultStr = HttpHelper.Request(url, RequestType.POST, data.sku.ToJson(), "application/json", timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<api_pps_sku_status_response_dto>();
                if (result == null)
                {
                    return new List<api_pps_sku_status_response_dto.sku_dto>() { };
                }
                else
                {
                    return result.result;
                }
            }
            catch (Exception ex)
            {
                throw new Exception("pps sku 刊登状态接口异常： " + ex.Message);
                throw new Exception("pps sku 刊登状态接口异常： " + ex.StackTrace);
            }
        }
        
        /// <summary>
        /// 获取平台费率
        /// </summary>
        /// <returns></returns>
        public static api_platform_fee_result_dto.result_dto GetPlatformFee(api_platform_fee_input_dto data)
        {
            try
            {
                //查询采购建议明细 
                string url = ConfigHelper.GetValue("PostPlatCategoryRate");
                string resultStr = HttpHelper.Request(url, RequestType.POST, data.datas.ToJson(), "application/json", timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<api_platform_fee_result_dto>();
                if (result == null)
                {
                    return new api_platform_fee_result_dto.result_dto() {};
                }
                else
                {
                    return result.result[0];
                }
            }
            catch (Exception ex)
            {
                return new api_platform_fee_result_dto.result_dto() { };
                //throw new Exception("平台费 接口异常： " + ex.Message);
                //throw new Exception("平台费 接口异常： " + ex.StackTrace);
            }
        }
        
        /// <summary>
        /// 获取平台分类
        /// </summary>
        /// <returns></returns>
        public static List<api_plat_category_dto> GetPlatformCategory(api_platform_category_input_dto data)
        {
            try
            {
                //查询采购建议明细 
                string url = ConfigHelper.GetValue("api_plat_category");
                string resultStr = HttpHelper.Request(url+ $"?plat={data.plat}&site={data.site}", RequestType.GET, timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<api_platform_category_result_dto>();
                if (result == null)
                {
                    return new List<api_plat_category_dto>(){ } ;
                }
                else
                {
                    return result.result;
                }
            }
            catch (Exception ex)
            {
                throw new Exception("平台分类 接口异常： " + ex.Message);
                throw new Exception("平台分类 接口异常： " + ex.StackTrace);
            }
        }

        /// <summary>
        /// 获取预估物流费用
        /// </summary>
        /// <returns></returns>
        public static api_logistic_query_result_dto.line_dto GetFilterLogisticsAssignLine(api_logistic_query_input_dto data)
        {
            try
            {
                var parameter_str = $"?LineCodes={data.LineCodes}";
                parameter_str += $"&endCountries={data.endCountries}";
                parameter_str += $"&Long={data.Long}";
                parameter_str += $"&width={data.width}";
                parameter_str += $"&high={data.high}";
                parameter_str += $"&weightKg={data.weightKg}";
                parameter_str += $"&startPoint={data.startPoint}";
                //parameter_str += $"&warehouseNo={data.warehouseNo}";
                //parameter_str += $"orderPriceCNY={data.orderPriceCNY}";
                parameter_str += $"&platform={data.platform}";
                parameter_str += $"&Site={data.Site}";

                //查询采购建议明细 
                string url = ConfigHelper.GetValue("ApiLogisticsGetFilterLogisticsAssignLine");
                string resultStr = HttpHelper.Request(url+ parameter_str, RequestType.GET, timeout: 1000 * 60 * 60 * 24);
                var result = resultStr.ToObj<api_logistic_query_result_dto>();
                if (result == null || result.Data == null || result.Data.successLines == null || result.Data.successLines.Count <= 0)
                {
                    throw new Exception("未查询到物流费用");
                }
                else
                {
                    return result.Data.successLines[0];
                }
            }
            catch (Exception ex)
            {
                throw new Exception(" lms 接口异常： " + ex.Message);
                throw new Exception(" lms 接口异常： " + ex.StackTrace);
            }
        }
    }
}
