﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ReportInvestReturnController : ControllerBase
    {
        #region 安全库存规则

        [HttpGet]
        [BrowseLog("Bailun_aims", "访问【百伦自动周转系统】->【ip+de投资回报分析】->【搜索】页面", 0)]
        public JsonResult AnaList(int limit, int offset, string order, string sort)
        {
            var total = 0;
            var service = new Services.ReportInvestReturnService();
            var list = service.AnaList(new Condition_ConfigPromotion { }, offset, limit, ref total);

            return new JsonResult(new
            {
                rows = list,
                total = total,
            });
        }

        #endregion
    }
}