﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 投资回报分析表
    /// </summary>
    public class dc_report_invest_return_analysis
    {
        public int id { get; set; }
        public string sku { get; set; }
        public string project { get; set; }
        public string sku_name { get; set; }
        public decimal price { get; set; }
        public DateTime gmt_create_time { get; set; }
        public DateTime gmt_update_time { get; set; }
        public string create_user { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }
        public string warehouse_name { get; set; }
        /// <summary>
        /// 总库存（在库+在途）
        /// </summary>
        public decimal stock { get; set; }
        /// <summary>
        /// 总金额 （在库+在途）
        /// </summary>
        public decimal stock_amount { get; set; }
        /// <summary>
        /// /日均销量 30天日均销量占比50%，7天日均销量占比50%。 来算日均销量。
        /// </summary>
        public decimal sales_day_average { get; set; }

        /// <summary>
        /// 销售订单转人民币汇率
        /// </summary>
        public decimal? seller_order_exchange_rate { get; set; }
        /// <summary>
        /// 过去30天销量
        /// </summary>
        public decimal sales_day_30 { get; set; }

        /// <summary>
        /// 过去7天销量
        /// </summary>
        public decimal sales_day_7 { get; set; }

        /// <summary>
        /// 出单天数 (总)
        /// </summary>
        public decimal order_days { get; set; }

        /// <summary>
        /// 出单天数 (过去30天)
        /// </summary>
        public decimal consume_days_30 { get; set; }

        /// <summary>
        /// 首次出单日期
        /// </summary>
        public DateTime? first_order_date { get; set; }
        /// <summary>
        /// 最后出单日期
        /// </summary>
        public DateTime? last_order_date { get; set; }
        /// <summary>
        /// 30天利润
        ///预计30天内销量，可售天数大于30天的，则为加权日均销量*30，可售天数小于30天的，则为加权日均销量* 可售天数
        ///预计30天内销售额=预计30天内销量* 单位售价
        ///预计30天营业利润=预计30天内销量* 单位售价*(1-最近1个月的款率-最近1个月的平台费率最近1个月的广告费率)-预计30天内销量* 单位采购成本
        /// </summary>
        public decimal profit_30_forecast { get; set; }
        /// <summary>
        /// 单位运费
        /// </summary>
        public decimal freight_unit_price { get; set; }

        /// <summary>
        /// 可售天数：
        ///总库存除于加权日均销量得出可售天数
        /// </summary>
        public decimal vendibility_days { get; set; }
        /// <summary>
        /// 预测30天销量
        /// </summary>
        public decimal sales_day_30_forecast { get; set; }
        /// <summary>
        /// 最近30天的平均销售单价
        /// </summary>
        public decimal gmv_day30_avg_unit_price_cny { get; set; }
        /// <summary>
        /// 预计30天销售额
        /// </summary>
        public decimal gmv_day_30_forecast_cny { get; set; }
        /// <summary>
        /// 最近30天的广告费（usd）
        /// </summary>
        public decimal adfee_day_30 { get; set; }

        /// <summary>
        /// 最近30天的平台费
        /// </summary>
        public decimal platform_fee_day_30 { get; set; }
        /// <summary>
        /// 最近30天退款金额
        /// </summary>
        public decimal refund_amount_day_30 { get; set; }
        /// <summary>
        /// 最近30天的销售额（usd）
        /// </summary>
        public decimal amount_total_day_30 { get; set; }
        /// <summary>
        /// 广告费率 （最近30天的广告费/最近30天的销售额）
        /// </summary>
        public decimal adfee_rate { get; set; }
        /// <summary>
        /// 平台费率 （最近30天的广告费/最近30天的销售额）
        /// </summary>
        public decimal platform_fee_rate { get; set; }
        /// <summary>
        /// 退款率 （最近30天退款金额/总销售额）
        /// </summary>
        public decimal refund_rate { get; set; }
        /// <summary>
        /// 采购在途数量
        /// </summary>
        public decimal quantity_purchase { get; set; }
        /// <summary>
        /// 采购在途金额
        /// </summary>
        public decimal quantity_purchase_amount { get; set; }

        /// <summary>
        /// 头程在途
        /// </summary>
        public decimal quantity_transfer { get; set; }

        /// <summary>
        /// 头程在途金额
        /// </summary>
        public decimal quantity_transfer_amount { get; set; }

        /// <summary>
        /// 在库库存
        /// </summary>
        public decimal library_stock { get; set; }
        /// <summary>
        /// 在库金额
        /// </summary>
        public decimal library_stock_amount { get; set; }
        /// <summary>
        /// 预估运费： 现在的总库存数（在途和在库）占用的库存运费
        /// </summary>
        public decimal estimated_freight { get; set; }

        /// <summary>
        /// 库存分数
        /// </summary>
        public decimal stock_score { get; set; }
    }
}
