﻿using System;

namespace AutoTurnOver.Models.dc_base_purchase
{
    /// <summary>
    /// 查询推送采购系统明细返回参数
    /// </summary>
    public class dc_purchase_advise_sku_output_dto
    {
        /// <summary>
        /// 采购计划单号
        /// </summary>
        public string plan_nos { get; set; }

        /// <summary>
        /// 百伦sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 供应商货号sku
        /// </summary>
        public string supplier_sku { get; set; }

        /// <summary>
        /// 日期
        /// </summary>
        public string create_order_date { get; set; }

        /// <summary>
        /// 产品英文名称
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 推送时间
        /// </summary>
        public DateTime push_date { get; set; }

        public string push_dateStr => push_date.ToString("yyyy-MM-dd HH:mm:ss ");

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

       /// <summary>
       /// 供应商名称
       /// </summary>
        public string suppliers_name { get; set; }

        /// <summary>
        /// 下单数量
        /// </summary>
        public int quantity_actual { get; set; }

        /// <summary>
        /// 产品单价
        /// </summary>
        public decimal unit_price { get; set; }
    }
}
