﻿using AutoTurnOver.DB;
using AutoTurnOver.Models;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Text;

namespace AutoTurnOver.Services
{
    public class CashFlowServices
    {
        public List<dynamic> GetView(report_cash_flow_view_search_dto search_data)
        {
            var order_list = report_cash_flow_dao.GetView(search_data);
            List<dynamic> datas = new List<dynamic>();
            foreach (var item in order_list)
            {
                dynamic o = new ExpandoObject();
                o.date_type = item.date_type;
                o.date_type_str = item.date_type_str;
                o.remarks = item.remarks;
                foreach (var dat_item in item.dates)
                {
                    var dic = (IDictionary<string, object>)o;
                    dic["occur_" + (dat_item.date_title)] = new { val = Math.Round(dat_item.occur_val, 2), btime = dat_item.btime, etime = dat_item.etime, data_type = item.date_type };
                    if(
                        item.date_type == (int)dc_report_cash_flow_log_data_type_enum.销售数量
                        //|| item.date_type==(int)dc_report_cash_flow_log_data_type_enum.利润 
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.退款
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.平台费用
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.释放销售成本
                        //|| item.date_type == (int)dc_report_cash_flow_log_data_type_enum.释放头程费用
                        )
                    {

                    }
                    else
                    {
                        dic["pay_" + (dat_item.date_title)] = new { val = Math.Round(dat_item.pay_val, 2), btime = dat_item.btime, etime = dat_item.etime, data_type = item.date_type };
                    }
                    
                }

                datas.Add(o);
            }

            return datas;

        }

        public List<dc_report_cash_flow_log_dto> Export(dc_report_cash_flow_log_export_search_dto search)
        {
            return report_cash_flow_dao.Export(search);
        }
    }
}
