﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    /// <summary>
    /// 现金流
    /// </summary>
    public class dc_report_cash_flow_log
    {
        public int id { get; set; }

        public string warehouse_code { get; set; }
        public string platform_type { get; set; }
        public string bailun_sku { get; set; }
        /// <summary>
        /// 1 = 销售数量 2 = 售金额 3 = 退款  4 = 利润  5 =平台费用  6=释放销售成本  7 = 释放头程费用  8 = 尾程费用  9 = 新增采购费用 10 =  新增头程费用
        /// </summary>
        public int data_type { get; set; }
        /// <summary>
        /// 1 = 实时  2 = 后付 3 = 后收 4 =预付
        /// </summary>
        public int pay_type { get; set; }
        /// <summary>
        /// 发送数值
        /// </summary>
        public decimal val { get; set; }
        /// <summary>
        /// 发送时间
        /// </summary>
        public DateTime occur_time { get; set; }
        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime pay_time { get; set; }
        /// <summary>
        /// 相关单号
        /// </summary>
        public string no { get; set; }
        /// <summary>
        /// 项目
        /// </summary>
        public string item { get; set; }
        /// <summary>
        /// 项目编号
        /// </summary>
        public string item_no { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string remarks { get; set; }

        /// <summary>
        /// 是否作废
        /// </summary>
        public int is_delete { get; set; }
        public DateTime? update_time { get; set; }
    }

    public class dc_report_cash_flow_log_dto: dc_report_cash_flow_log
    {
        public string data_type_str
        {
            get
            {
                return ((dc_report_cash_flow_log_data_type_enum)data_type).ToString();
            }
        }

        public string warehouse_name { get; set; }
    }

    /// <summary>
    ///  1 = 销售数量 2 = 销售金额 3 = 退款  4 = 利润  5 =平台费用  6=释放销售成本  7 = 释放头程费用  8 = 尾程费用  9 = 新增采购费用 10 =  新增头程费用
    /// </summary>
    public enum dc_report_cash_flow_log_data_type_enum 
    {
        销售数量 = 1,
        销售金额  =2,
        退款 = 3,
        利润 = 4,
        平台费用 = 5,
        释放销售成本 = 6,
        释放头程费用 = 7,
        尾程费用 =8,
        新增采购费用 = 9,
        新增头程费用 = 10
    }

    public enum dc_report_cash_flow_log_pay_type_enum
    {
        实时 = 1,
        后付 = 2,
        后收 = 3,
        预付 = 4,
    } 
    public enum dc_report_cash_flow_settlement_type_enum
    {
        等长顺延 = 1,
        月度固定 = 2
    }

    /// <summary>
    /// 现金流配置
    /// </summary>
    public class dc_report_cash_flow_config
    {
        public int id { get; set; }
        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 数据类型
        /// </summary>
        public int data_type { get; set; }

        /// <summary>
        /// 结算方式
        /// </summary>
        public int settlement_type { get; set; }

        
        public int settlement_val { get; set; }
    }

    public class dc_report_cash_flow_config_dto: dc_report_cash_flow_config
    {
        public string data_type_str { get {
                return ((dc_report_cash_flow_log_data_type_enum)data_type).ToString();
            } }
        
        public string settlement_type_str { get {
                return ((dc_report_cash_flow_settlement_type_enum)settlement_type).ToString();
            } }

    }

    public class dc_report_cash_flow_config_search_dto
    {
        public string data_type { get; set; }
    }

    public class report_cash_flow_view_dto
    {
        public string remarks { get; set; }
        public string date_type_str { get; set; }
        public int date_type { get; set; }
        public List<date_dto> dates { get; set; }
        public class date_dto
        {
            public string date_title { get; set; }
           
            public DateTime btime { get; set; }
            public DateTime etime { get; set; }
            public decimal occur_val { get; set; }
            public decimal pay_val { get; set; }
        }
    }

    public class report_cash_flow_view_search_dto
    {
        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
    }

    public class dc_report_cash_flow_log_export_search_dto
    {
        public DateTime? btime { get; set; }
        public DateTime? etime { get; set; }
        public int? data_type { get; set; }
        /// <summary>
        /// 1 = 根据发生时间查询
        /// 2 = 根据支付时间查询
        /// </summary>
        public int? type { get; set; }
    }
}
