﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using AutoTurnOver.Common;
using AutoTurnOver.Models;
using AutoTurnOver.Services;
using AutoTurnOver.Utility;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;

namespace AutoTurnOver.Controllers
{
    [Route("api/[controller]")]
    [ApiController]
    [NoLogin]
    public class ApiController : ControllerBase
    {

        [HttpGet("Test")]
        public ActionResult<RequestResultDto> Test()
        {
            return new RequestResultDto { success = true, data = 
                HttpHelper.Request("http://10.0.3.13/api/Logistics/ApiLogistics/GetPlatOfficialLine?PlatName=aliexpress&PlatSite=US&EndCountry=US&Skus=&WeightKg=0.015&Size=7,4,1&ElectrifiedType=1&SellMoney=1.6000&Currency=USD&OfficialLine=&postWay=&distribution=&logisticsId=0&EnterZip=&isIgnoreVolumeWeight=True&ruleStartPoint=1", RequestType.GET, timeout: 1000 * 60 * 60 * 24)
        };
        }

        [HttpPost("GetOutStockPage")]
        public ActionResult<RequestResultDto> GetOutStockPage([FromBody] dc_quantity_out_stock_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetOutStockPage(search) };
        } 
        
        [HttpPost("GetSkuSalesVolume")]
        public ActionResult<RequestResultDto> GetSkuSalesVolume([FromBody] api_sku_sales_volume_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetSkuSalesVolume(search) };
        } 
        
        [HttpPost("GetSkuTort")]
        public ActionResult<RequestResultDto> GetSkuTort([FromBody] api_sku_tort_search_dto search)
        {
            return new RequestResultDto { success = true, data = ApiServices.GetSkuTort(search) };
        }

        /// <summary>
        /// 获取oms 订单数据
        /// </summary>
        /// <param name="search"></param>
        /// <returns></returns>
        [HttpPost("GetOmsSkuFullPage")]
        public  async Task<ActionResult<RequestResultDto>> GetOmsSkuFullPage([FromBody] dc_base_oms_sku_full_search_dto search)
        {
            return new RequestResultDto { success = true, data = await ApiServices.GetOmsSkuFullPage(search) };
        }

        

        [HttpPost("Buys")]
        public JsonResult Buys([FromBody]AverageQueryDto queryDto)
        {
            try
            {
                return new JsonResult(new
                {
                    data = PurchaseAverageTargetServices.GetList(queryDto.sids, queryDto.skus),
                    success = true,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                });
            }
        }



        /// <summary>
        /// 实时库存
        /// </summary>
        /// <param name="sku"></param>
        /// <param name="warehousecode"></param>
        /// <param name="offset"></param>
        /// <param name="limit"></param>
        /// <returns></returns>
        [HttpGet("RealtimeStockList")]
        public JsonResult RealtimeStockList(int? monitor_status, int? searchType, string key_words, string warehousecode, string buyer_name, string supplier_name, int offset, int limit, string order, string sort, string warehousetype, int? warehousearea, int? has_tort = null, string categoryIds = null,
           DateTime? start_date = null, DateTime? end_date = null, DateTime? f_start_date = null, DateTime? f_end_date = null, int? product_type = null, bool is_warehouse_sum = false)
        {

            try
            {
                var services = new DailyServices();
                var total = 0;
                var list = services.RealtimeList(monitor_status, searchType, key_words, warehousecode, supplier_name, offset, limit, ref total, warehousetype, warehousearea, order: order, sort: sort, has_tort: has_tort, categoryIds: categoryIds, buyer_name: buyer_name, start_date: start_date, end_date: end_date, f_start_date: f_start_date, f_end_date: f_end_date, product_type: product_type, is_warehouse_sum:is_warehouse_sum);

                return new JsonResult(new
                {
                    rows = list,
                    total = total,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    stack_trace = ex.StackTrace
                });
            }

        }

        public class GetSkus_dto
        {
            public string skus { get; set; }
        }
        [HttpPost("GetSkus")]
        public JsonResult GetSkus([FromBody]GetSkus_dto queryDto)
        {
            try
            {
                return new JsonResult(new
                {
                    result = new DailyServices().GetSkus(queryDto.skus),
                    success = true,
                    statusCode=200
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                    statusCode = 500
                });
            }
        }

        [HttpPost("FirstOrderSkuAdd")]
        public JsonResult FirstOrderSkuAdd([FromBody]dc_auto_first_order_sku_input_dto inputData)
        {

            try
            {

                new FirstOrderService().Add(inputData);
                return new JsonResult(new
                {
                    success = true,
                });
            }
            catch (Exception ex)
            {
                return new JsonResult(new
                {
                    message = ex.Message,
                    success = false,
                });
            }
        }
    }
}