﻿using System;
using System.Collections.Generic;
using System.Text;

namespace AutoTurnOver.Models
{
    public class transfer_profit_dto
    {
        public string name { get; set; }
        public string remarks { get; set; }
        public List<day_dto> days { get; set; }

        public class day_dto
        {
            public DateTime date { get; set; }
            public string date_str { get {
                    return date.ToString("MM-dd"+$"({Sinicization(date.DayOfWeek)})");
                } }

            public decimal? val { get; set; }
        }

        public static string Sinicization(DayOfWeek week)
        {
            switch (week)
            {
                case DayOfWeek.Friday:
                    return "周五";
                case DayOfWeek.Monday:
                    return "周一";
                case DayOfWeek.Saturday:
                    return "周六";
                case DayOfWeek.Sunday:
                    return "周日";
                case DayOfWeek.Thursday:
                    return "周四";
                case DayOfWeek.Tuesday:
                    return "周二";
                case DayOfWeek.Wednesday:
                    return "周三";
                default:
                    return "";
                    break;
            }
        }
    }
}
