﻿using AutoTurnOver.Models.ApiDto;
using AutoTurnOver.Utility;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Net;
using System.Text;
using System.Linq;

namespace AutoTurnOver.Services
{
    public class ApiServices
    {
        /// <summary>
        /// 获取一二级的百伦分类数据
        /// </summary>
        /// <returns></returns>
        public static List<CategoryDto> GetCategoryAll()
        {
            List<CategoryDto> clsit = new List<CategoryDto>();
            clsit.AddRange(GetCategoryList(1));
            clsit.AddRange(GetCategoryList(2));
            return clsit;
        }

        public static List<CategoryDto> GetCategoryList(int level = 1)
        {
            if (level == 0)
            {
                List<CategoryDto> datas = new List<CategoryDto>();
                var tempLevel = 1;
                while (true)
                {
                    var tempDatas = GetCategoryList(tempLevel);
                    if (tempDatas != null && tempDatas.Count >= 1 && level <= 4)
                    {
                        datas.AddRange(tempDatas);
                    }
                    else
                    {
                        return datas;
                    }
                    tempLevel++;

                }
            }
            string appId = "SystemDC";
            string appKey = "YmFpbHVuREM=";
            string url = "http://api.sku.bailuntec.com/api/BailunCateData/GetAllCategoryList";

            List<CategoryDto> result = new List<CategoryDto>();

            ApiEntrance model = new ApiEntrance();
            model.code = appId;
            model.data = level.ToString();

            string sign = Security.md5Encrypt(appKey + model.code + Security.md5Encrypt(model.key + model.data));
            string resultStr = HttpHelper.Request(url + $"?sign={sign}&appId={appId}&level={level}", RequestType.GET);
            ApiResult apiResult = resultStr.ToObj<ApiResult>();
            if (apiResult.result_code == 1)
            {
                result = WebUtility.UrlDecode(apiResult.data).ToObj<List<CategoryDto>>().Where(s => s.C_LEVEL == level).ToList();
            }
            return result;

        }

        /// <summary>
        /// 根据ID查询分类
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public static CategoryDto GetCategoryById(int id)
        {
            var all = GetCategoryAll();
            return all.SingleOrDefault(s => s.C_ID == id);
        }

        /// <summary>
        /// 查询相关的子节点
        /// </summary>
        /// <param name="all"></param>
        /// <param name="id"></param>
        /// <returns></returns>
        public static List<CategoryDto> GetClientNodesByIds(List<int> ids)
        {
            if (ids == null || ids.Count <= 0)
            {
                return new List<CategoryDto>();
            }
            List<CategoryDto> datas = new List<CategoryDto>();
            var all = GetCategoryList(0);
            foreach (var item in ids)
            {
                datas.AddRange(GetClientNodesById(all, item));
            }
            return datas;
        }

        /// <summary>
        /// 查询相关的子节点
        /// </summary>
        /// <param name="ids"></param>
        /// <returns></returns>
        public static List<CategoryDto> GetClientNodesById(List<CategoryDto> all, int id)
        {

            // 查询所有数据
            if (all == null)
            {
                all = GetCategoryList(0);
            }
            List<CategoryDto> clients = all.Where(s => s.C_ID == id).ToList();
            var cNodes = all.Where(s => s.C_PARENTID == id).ToList();
            if (cNodes != null || cNodes.Count >= 1)
            {
                foreach (var item in cNodes)
                {
                    clients.AddRange(GetClientNodesById(all, item.C_ID));
                }
            }
            return clients;


        }

        /// <summary>
        /// 推送采购计划
        /// </summary>
        public static BuyOutputResult PushBuyPlan(mPlanToPurchaseDto data)
        {
            //查询采购建议明细 
            string url = ConfigHelper.GetValue("PushBuyPlan");
            string resultStr = HttpHelper.Request(url, RequestType.POST, "obj=" + WebUtility.UrlDecode(data.ToJson()));
            var result = resultStr.ToObj<BuyOutputResult>();
            if (result == null)
            {
                throw new Exception("推送失败");
            }
            if (!result.IsSuccessed)
            {
                throw new Exception(result.Message);
            }
            return result;
        }
    }
}
